/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.confluence.webhook;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.remotable.plugin.product.EventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.AttachmentEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.BlogPostEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.CommentEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.ConfluenceEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.LabelEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.PageChildrenReorderEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.PageEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.PageMoveEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.SearchPerformedEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.SecurityEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.SpaceEventMapper;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.UserStatusEventMapper;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.EventSerializers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfluenceEventSerializerFactory
implements EventSerializerFactory<ConfluenceEvent> {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceEventSerializerFactory.class);
    private final List<EventMapper<ConfluenceEvent>> mappers;

    public ConfluenceEventSerializerFactory(UserManager userManager, SettingsManager confluenceSettingsManager) {
        this.mappers = ImmutableList.of((Object)new LabelEventMapper(userManager, confluenceSettingsManager), (Object)new UserStatusEventMapper(userManager, confluenceSettingsManager), (Object)new SearchPerformedEventMapper(userManager, confluenceSettingsManager), (Object)new AttachmentEventMapper(userManager, confluenceSettingsManager), (Object)new PageChildrenReorderEventMapper(userManager, confluenceSettingsManager), (Object)new PageMoveEventMapper(userManager, confluenceSettingsManager), (Object)new PageEventMapper(userManager, confluenceSettingsManager), (Object)new BlogPostEventMapper(userManager, confluenceSettingsManager), (Object)new SpaceEventMapper(userManager, confluenceSettingsManager), (Object)new CommentEventMapper(userManager, confluenceSettingsManager), (Object)new SecurityEventMapper(userManager, confluenceSettingsManager), (Object)new ConfluenceEventMapper(userManager, confluenceSettingsManager), (Object[])new EventMapper[0]);
    }

    public EventSerializer create(ConfluenceEvent event) {
        for (EventMapper<ConfluenceEvent> mapper : this.mappers) {
            if (!mapper.handles(event)) continue;
            return EventSerializers.forMap((Object)event, mapper.toMap(event));
        }
        log.warn(String.format("Event %s was not recognised by any Event to WebHook mapper.", event.getClass().getName()));
        return EventSerializers.forMap((Object)event, (Map)ImmutableMap.builder().build());
    }
}

