/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.util.redirect;

import com.atlassian.plugin.remotable.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.remotable.spi.RemotablePluginAccessor;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;

public final class RedirectServlet
extends HttpServlet {
    private static final String APP_KEY_PARAM = "app_key";
    private static final String APP_URL_PARAM = "app_url";
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final UserManager userManager;

    public RedirectServlet(UserManager userManager, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory) {
        this.userManager = userManager;
        this.remotablePluginAccessorFactory = remotablePluginAccessorFactory;
    }

    public static String getPermanentRedirectUrl(String appKey, URI path) {
        return new UriBuilder(Uri.parse("/plugins/servlet/redirect/permanent")).addQueryParameter(APP_KEY_PARAM, appKey).addQueryParameter(APP_URL_PARAM, path.toString()).toString();
    }

    public static String getOAuthRedirectUrl(String baseUrl, String appKey, URI path) {
        return RedirectServlet.getOAuthRedirectUrl(baseUrl, appKey, path, Collections.<String, String>emptyMap());
    }

    public static String getRelativeOAuthRedirectUrl(String appKey, URI path, Map<String, String> params) {
        return RedirectServlet.getOAuthRedirectUrl("", appKey, path, params);
    }

    public static String getOAuthRedirectUrl(String baseUrl, String appKey, URI path, Map<String, String> params) {
        UriBuilder builder = new UriBuilder(Uri.parse(baseUrl + "/plugins/servlet/redirect/oauth")).addQueryParameter(APP_KEY_PARAM, appKey).addQueryParameter(APP_URL_PARAM, path.toString());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RedirectType redirectType = RedirectType.fromRequest(req);
        String appkey = req.getParameter(APP_KEY_PARAM);
        Validate.notEmpty((String)appkey, (String)String.format("%s parameter is required", APP_KEY_PARAM));
        String appUrl = req.getParameter(APP_URL_PARAM);
        Validate.notEmpty((String)appUrl, (String)String.format("%s parameter is required", APP_URL_PARAM));
        RemotablePluginAccessor remotablePluginAccessor = this.remotablePluginAccessorFactory.get(appkey);
        String fullAppUrl = redirectType.isSign() ? this.getFullSignedUrl(remotablePluginAccessor, appUrl, req.getParameterMap()) : this.getFullUrl(remotablePluginAccessor, appUrl, req.getParameterMap());
        resp.setStatus(redirectType.getStatusCode());
        resp.addHeader("Location", fullAppUrl);
        resp.getOutputStream().close();
    }

    private String getFullUrl(RemotablePluginAccessor remotablePluginAccessor, String appRelativeUrl, Map<String, String[]> params) {
        Uri targetUrl = Uri.parse(appRelativeUrl);
        return remotablePluginAccessor.createGetUrl(targetUrl.toJavaUri(), params);
    }

    private String getFullSignedUrl(RemotablePluginAccessor remotablePluginAccessor, String appRelativeUrl, Map<String, String[]> parameterMap) {
        Uri targetUrl = Uri.parse(appRelativeUrl);
        HashMap params = Maps.newHashMap(parameterMap);
        params.put("user_id", new String[]{this.userManager.getRemoteUsername()});
        params.putAll(Maps.transformValues(targetUrl.getQueryParameters(), (Function)new Function<List<String>, String[]>(){

            public String[] apply(List<String> strings) {
                return strings.toArray(new String[strings.size()]);
            }
        }));
        return remotablePluginAccessor.signGetUrl(targetUrl.toJavaUri(), (Map)params);
    }

    private static enum RedirectType {
        OAUTH_TEMPORARY("oauth", true, 302),
        PERMANENT("permanent", false, 301);

        private final String type;
        private final boolean sign;
        private final int statusCode;

        private RedirectType(String type, boolean sign, int statusCode) {
            this.type = type;
            this.sign = sign;
            this.statusCode = statusCode;
        }

        public boolean isSign() {
            return this.sign;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public static RedirectType fromRequest(HttpServletRequest req) {
            String requestUri = req.getRequestURI();
            if (requestUri != null) {
                String typeId = requestUri.substring(requestUri.lastIndexOf("/") + 1);
                for (RedirectType redirectType : RedirectType.values()) {
                    if (!redirectType.type.equals(typeId)) continue;
                    return redirectType;
                }
                throw new IllegalArgumentException("Redirect type not found: " + typeId);
            }
            throw new IllegalArgumentException("Redirect type not found");
        }
    }
}

