/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.oauth;

import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.util.Check;
import com.atlassian.plugin.remotable.plugin.OAuthLinkManager;
import com.atlassian.plugin.remotable.plugin.module.oauth.NonUserAdminPrincipal;
import com.atlassian.plugin.remotable.plugin.util.DefaultMessage;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OAuth2LOAuthenticator
implements Authenticator {
    private static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    private static final Logger log = LoggerFactory.getLogger(OAuth2LOAuthenticator.class);
    private final OAuthLinkManager oAuthLinkManager;
    private final AuthenticationController authenticationController;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final String ourConsumerKey;

    @Autowired
    public OAuth2LOAuthenticator(AuthenticationController authenticationController, ApplicationProperties applicationProperties, OAuthLinkManager oAuthLinkManager, UserManager userManager, ConsumerService consumerService) {
        this.oAuthLinkManager = oAuthLinkManager;
        this.userManager = userManager;
        this.authenticationController = (AuthenticationController)Check.notNull((Object)authenticationController, (Object)"authenticationController");
        this.applicationProperties = (ApplicationProperties)Check.notNull((Object)applicationProperties, (Object)"applicationProperties");
        this.ourConsumerKey = consumerService.getConsumer().getKey();
    }

    public Authenticator.Result authenticate(HttpServletRequest request, HttpServletResponse response) {
        Principal user;
        String consumerKey;
        OAuthMessage message = OAuthServlet.getMessage(request, OAuth2LOAuthenticator.getLogicalUri(request));
        try {
            String authHeader;
            consumerKey = message.getConsumerKey();
            this.oAuthLinkManager.validateOAuth2LORequest(message);
            if (this.ourConsumerKey.equals(consumerKey) && (authHeader = request.getHeader("Authorization")) != null) {
                consumerKey = OAuth2LOAuthenticator.extractPluginKey(authHeader);
            }
        }
        catch (IOException e) {
            log.warn("Exception authenticating request", (Throwable)e);
            this.sendError(response, 500, message);
            return new Authenticator.Result.Failure((Message)new DefaultMessage("OAuth exception:" + e.getMessage()));
        }
        catch (URISyntaxException e) {
            log.warn("Exception authenticating request", (Throwable)e);
            this.sendError(response, 500, message);
            return new Authenticator.Result.Failure((Message)new DefaultMessage("OAuth exception:" + e.getMessage()));
        }
        catch (OAuthProblemException ope) {
            OAuth2LOAuthenticator.logOAuthProblem(message, ope, log);
            try {
                OAuthServlet.handleException(response, (Exception)((Object)ope), this.applicationProperties.getBaseUrl());
            }
            catch (Exception e) {
                log.error("Failure reporting OAuth error to client", (Throwable)e);
            }
            return new Authenticator.Result.Failure((Message)new DefaultMessage(ope.getMessage()));
        }
        catch (OAuthException e) {
            log.warn("Exception authenticating request", (Throwable)e);
            this.sendError(response, 500, message);
            return new Authenticator.Result.Failure((Message)new DefaultMessage("OAuth exception:" + e.getMessage()));
        }
        String userId = request.getParameter("user_id");
        if (userId != null && !"".equals(userId)) {
            user = this.userManager.resolve(userId);
            if (user == null || !this.authenticationController.canLogin(user, request)) {
                log.warn("Access denied to user '{}' because that user cannot login", (Object)userId);
                this.sendError(response, 401, message);
                return new Authenticator.Result.Failure((Message)new DefaultMessage("Permission denied"));
            }
        } else {
            user = NonUserAdminPrincipal.INSTANCE;
        }
        request.setAttribute("Plugin-Key", (Object)consumerKey);
        log.info("Authenticated app '{}' as user '{}' successfully", (Object)consumerKey, (Object)user.getName());
        return new Authenticator.Result.Success(user);
    }

    static String extractPluginKey(String authHeader) {
        return authHeader.replaceAll(".* realm=\"([^\"]*)\".*", "$1");
    }

    public static String getLogicalUri(HttpServletRequest request) {
        String uriPathBeforeForwarding = (String)request.getAttribute(FORWARD_REQUEST_URI);
        if (uriPathBeforeForwarding == null) {
            return null;
        }
        URI newUri = URI.create(request.getRequestURL().toString());
        try {
            return new URI(newUri.getScheme(), newUri.getAuthority(), uriPathBeforeForwarding, newUri.getQuery(), newUri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            log.warn("forwarded request had invalid original URI path: " + uriPathBeforeForwarding);
            return null;
        }
    }

    public static void logOAuthProblem(OAuthMessage message, OAuthProblemException ope, Logger logger) {
        if ("timestamp_refused".equals(ope.getProblem())) {
            logger.warn("Rejecting OAuth request for url \"{}\" due to invalid timestamp ({}). This is most likely due to our system clock not being synchronized with the consumer's clock.", new Object[]{message.URL, ope.getParameters()});
        } else if (logger.isDebugEnabled()) {
            logger.warn("Problem encountered authenticating OAuth client request for url \"" + message.URL + "\", error was \"" + ope.getProblem() + "\", with parameters \"" + ope.getParameters() + "\"", (Throwable)ope);
        } else {
            logger.warn("Problem encountered authenticating OAuth client for url \"{}\", error was \"{}\", with parameters \"{}\"", new Object[]{message.URL, ope.getProblem(), ope.getParameters()});
        }
    }

    private void sendError(HttpServletResponse response, int status, OAuthMessage message) {
        response.setStatus(status);
        try {
            response.addHeader("WWW-Authenticate", message.getAuthorizationHeader(this.applicationProperties.getBaseUrl()));
        }
        catch (IOException e) {
            log.error("Failure reporting OAuth error to client", (Throwable)e);
        }
    }
}

