/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.confluence;

import com.atlassian.confluence.content.render.xhtml.XhtmlCleaner;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.BigPipe;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.HtmlPromise;
import com.atlassian.plugin.remotable.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.remotable.plugin.module.confluence.MacroContentLinkParser;
import com.atlassian.plugin.remotable.plugin.module.confluence.MacroInstance;
import com.atlassian.plugin.remotable.plugin.util.http.CachingHttpContentRetriever;
import com.atlassian.plugin.remotable.plugin.util.http.ContentRetrievalErrors;
import com.atlassian.plugin.remotable.plugin.util.http.ContentRetrievalException;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class MacroContentManager
implements DisposableBean {
    public static final String BIG_PIPE_REQUEST_ID = "__big_pipe_request_id";
    private final EventPublisher eventPublisher;
    private final XhtmlCleaner xhtmlCleaner;
    private final MacroContentLinkParser macroContentLinkParser;
    private final CachingHttpContentRetriever cachingHttpContentRetriever;
    private final BigPipe bigPipe;
    private final UserManager userManager;
    private final XhtmlContent xhtmlUtils;
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final TemplateRenderer templateRenderer;
    private static final Logger log = LoggerFactory.getLogger(MacroContentManager.class);

    public MacroContentManager(EventPublisher eventPublisher, CachingHttpContentRetriever cachingHttpContentRetriever, MacroContentLinkParser macroContentLinkParser, BigPipe bigPipe, UserManager userManager, XhtmlContent xhtmlUtils, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory, TemplateRenderer templateRenderer) {
        this.eventPublisher = eventPublisher;
        this.cachingHttpContentRetriever = cachingHttpContentRetriever;
        this.bigPipe = (BigPipe)Preconditions.checkNotNull((Object)bigPipe);
        this.userManager = userManager;
        this.xhtmlUtils = xhtmlUtils;
        this.remotablePluginAccessorFactory = remotablePluginAccessorFactory;
        this.templateRenderer = templateRenderer;
        this.eventPublisher.register((Object)this);
        this.xhtmlCleaner = (XhtmlCleaner)ComponentLocator.getComponent(XhtmlCleaner.class);
        this.macroContentLinkParser = macroContentLinkParser;
    }

    public String getStaticContent(MacroInstance macroInstance) throws ContentRetrievalException {
        ContentEntityObject entity = macroInstance.getEntity();
        String requestId = macroInstance.getConversionContext().getPropertyAsString(BIG_PIPE_REQUEST_ID);
        if (requestId == null) {
            requestId = this.bigPipe.getRequestId();
            macroInstance.getConversionContext().setProperty(BIG_PIPE_REQUEST_ID, (Object)requestId);
        }
        String author = this.getUserToRenderMacroAs(entity);
        Map<String, String> urlParameters = macroInstance.getUrlParameters(author);
        Promise promise = macroInstance.getRemotablePluginAccessor().executeAsyncGet(author, macroInstance.getPath(), urlParameters, macroInstance.getHeaders(author)).fold((Function)new ContentHandlerFailFunction(this.templateRenderer), (Function)new HtmlToSafeHtmlFunction(macroInstance, urlParameters, this.macroContentLinkParser, this.xhtmlCleaner, this.xhtmlUtils));
        HtmlPromise contentPromise = this.bigPipe.promiseHtmlContent(promise);
        try {
            if ("display".equals(macroInstance.getConversionContext().getOutputType())) {
                return contentPromise.getInitialContent();
            }
            return (String)contentPromise.claim();
        }
        catch (RuntimeException e) {
            log.debug("Exception retrieving content", (Throwable)e);
            throw new ContentRetrievalException(Throwables.getRootCause((Throwable)e));
        }
    }

    private String getUserToRenderMacroAs(ContentEntityObject entity) {
        return entity != null && entity.getLastModifierName() != null ? entity.getLastModifierName() : this.userManager.getRemoteUsername();
    }

    @EventListener
    public void onPageEvent(PageEvent pageEvent) {
        if (!(pageEvent instanceof PageViewEvent)) {
            String pageId = pageEvent.getPage().getIdAsString();
            this.cachingHttpContentRetriever.flushCacheByUriPattern(Pattern.compile(".*page_id=" + pageId + ".*"));
        }
    }

    public void clearContentByPluginKey(String pluginKey) {
        URI displayUrl = this.remotablePluginAccessorFactory.get(pluginKey).getDisplayUrl();
        this.cachingHttpContentRetriever.flushCacheByUriPattern(Pattern.compile("^" + displayUrl + "/.*"));
    }

    public void clearContentByInstance(String pluginKey, String instanceKey) {
        URI displayUrl = this.remotablePluginAccessorFactory.get(pluginKey).getDisplayUrl();
        this.cachingHttpContentRetriever.flushCacheByUriPattern(Pattern.compile("^" + displayUrl + "/.*key=" + instanceKey + ".*"));
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private static class HtmlToSafeHtmlFunction
    implements Function<String, String> {
        private final MacroInstance macroInstance;
        private final Map<String, String> urlParameters;
        private final MacroContentLinkParser macroContentLinkParser;
        private final XhtmlCleaner xhtmlCleaner;
        private final XhtmlContent xhtmlUtils;

        public HtmlToSafeHtmlFunction(MacroInstance macroInstance, Map<String, String> urlParameters, MacroContentLinkParser macroContentLinkParser, XhtmlCleaner xhtmlCleaner, XhtmlContent xhtmlUtils) {
            this.macroInstance = macroInstance;
            this.urlParameters = urlParameters;
            this.macroContentLinkParser = macroContentLinkParser;
            this.xhtmlCleaner = xhtmlCleaner;
            this.xhtmlUtils = xhtmlUtils;
        }

        public String apply(String value) {
            value = this.macroContentLinkParser.parse(this.macroInstance.getRemotablePluginAccessor(), value, this.urlParameters);
            String cleanedXhtml = this.xhtmlCleaner.cleanQuietly(value, this.macroInstance.getConversionContext());
            try {
                return this.xhtmlUtils.convertStorageToView(cleanedXhtml, this.macroInstance.getConversionContext());
            }
            catch (Exception e) {
                log.warn("Unable to convert storage format for app {} with error {}", (Object)this.macroInstance.getRemotablePluginAccessor().getKey(), (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Error converting storage format", (Throwable)e);
                }
                throw new ContentRetrievalException("Unable to convert storage format to HTML: " + e.getMessage(), e);
            }
        }
    }

    private static final class ContentHandlerFailFunction
    implements Function<Throwable, String> {
        private TemplateRenderer templateRenderer;

        private ContentHandlerFailFunction(TemplateRenderer templateRenderer) {
            this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        }

        public String apply(Throwable t) {
            ContentRetrievalErrors errors;
            if (t instanceof ContentRetrievalException) {
                errors = ((ContentRetrievalException)t).getErrors();
            } else {
                errors = new ContentRetrievalErrors((List<String>)ImmutableList.of((Object)"An unknown error occurred."));
                log.warn("An unknown error occurred rendering the macro", t);
            }
            return this.renderErrors(errors);
        }

        private String renderErrors(ContentRetrievalErrors errors) {
            try {
                StringWriter writer = new StringWriter();
                this.templateRenderer.render("/velocity/macro/errors.vm", (Map)ImmutableMap.of((Object)"errors", (Object)errors), (Writer)writer);
                return ((Object)writer).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

