/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.license;

import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.plugin.license.LicenseStatus;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseRetriever
implements DisposableBean {
    private final PluginEventManager pluginEventManager;
    private final Cache<String, ServiceTracker> licenseManagers;
    private static final Logger log = LoggerFactory.getLogger(LicenseRetriever.class);

    @Autowired
    public LicenseRetriever(final BundleContext bundleContext, PluginEventManager pluginEventManager) {
        this.pluginEventManager = pluginEventManager;
        this.licenseManagers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ServiceTracker>(){

            public ServiceTracker load(String pluginKey) throws Exception {
                Bundle pluginBundle = BundleUtil.findBundleForPlugin(bundleContext, pluginKey);
                ServiceTracker tracker = new ServiceTracker(pluginBundle.getBundleContext(), PluginLicenseManager.class.getName(), null);
                tracker.open();
                return tracker;
            }
        });
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        String pluginKey = event.getPlugin().getKey();
        if (this.licenseManagers.asMap().containsKey(pluginKey)) {
            ServiceTracker tracker = (ServiceTracker)this.licenseManagers.getUnchecked((Object)pluginKey);
            tracker.close();
            this.licenseManagers.invalidate((Object)pluginKey);
        }
    }

    public Option<PluginLicense> getLicense(String pluginKey) {
        PluginLicenseManager licenseManager = (PluginLicenseManager)((ServiceTracker)this.licenseManagers.getUnchecked((Object)pluginKey)).getService();
        if (licenseManager != null) {
            return licenseManager.getLicense();
        }
        log.warn("No plugin license manager found for '{}'", (Object)pluginKey);
        return Option.none();
    }

    public LicenseStatus getLicenseStatus(String pluginKey) {
        return (LicenseStatus)((Object)this.getLicense(pluginKey).map((Function)new Function<PluginLicense, LicenseStatus>(){

            public LicenseStatus apply(PluginLicense input) {
                return input.isMaintenanceExpired() ? LicenseStatus.EXPIRED : LicenseStatus.ACTIVE;
            }
        }).getOrElse((Object)LicenseStatus.NONE));
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }
}

