/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.descriptor;

import com.atlassian.osgi.tracker.WaitableServiceTracker;
import com.atlassian.osgi.tracker.WaitableServiceTrackerFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.plugin.descriptor.DescriptorValidatorProvider;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.permission.PermissionsReader;
import com.atlassian.plugin.schema.descriptor.DescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.spi.Schema;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginDescriptorValidatorProvider
implements DescriptorValidatorProvider {
    private final Plugin plugin;
    private final ApplicationProperties applicationProperties;
    private final PermissionsReader permissionsReader;
    private WaitableServiceTracker<String, DescribedModuleDescriptorFactory> describedModuleFactories;

    @Autowired
    public PluginDescriptorValidatorProvider(PluginRetrievalService pluginRetrievalService, ApplicationProperties applicationProperties, WaitableServiceTrackerFactory waitableServiceTrackerFactory, PermissionsReader permissionsReader) {
        this.applicationProperties = applicationProperties;
        this.permissionsReader = permissionsReader;
        this.plugin = pluginRetrievalService.getPlugin();
        this.describedModuleFactories = waitableServiceTrackerFactory.create(DescribedModuleDescriptorFactory.class, new Function<DescribedModuleDescriptorFactory, String>(){

            public String apply(DescribedModuleDescriptorFactory input) {
                return String.valueOf(System.identityHashCode(input));
            }
        });
    }

    @Override
    public String getSchemaNamespace() {
        return this.applicationProperties.getBaseUrl() + "/rest/remotable-plugins/1/installer/schema/atlassian-plugin";
    }

    @Override
    public String getRootElementName() {
        return "AtlassianPluginType";
    }

    @Override
    public Iterable<Schema> getModuleSchemas() {
        HashSet schemas = Sets.newHashSet();
        for (DescribedModuleDescriptorFactory factory : this.describedModuleFactories.getAll()) {
            for (String key : factory.getModuleDescriptorKeys()) {
                Schema schema = factory.getSchema(key);
                if (schema == null) continue;
                schemas.add(schema);
            }
        }
        return schemas;
    }

    @Override
    public void performSecondaryValidations(Document document) throws InstallationFailedException {
        Set permissions = this.permissionsReader.readPermissionsFromDescriptor(document, InstallationMode.REMOTE);
        Collection moduleTypes = Collections2.transform((Collection)document.getRootElement().elements(), (Function)new Function<Element, String>(){

            public String apply(Element input) {
                return input.getName();
            }
        });
        for (DescribedModuleDescriptorFactory factory : this.describedModuleFactories.getAll()) {
            for (String key : factory.getModuleDescriptorKeys()) {
                if (!moduleTypes.contains(key)) continue;
                for (String permission : factory.getSchema(key).getRequiredPermissions()) {
                    if (permissions.contains(permission)) continue;
                    throw new InstallationFailedException("The permission '" + permission + " is required " + "to use the '" + key + "' module type");
                }
            }
        }
    }

    @Override
    public URL getSchemaUrl() {
        return this.plugin.getResource("/xsd/atlassian-plugin.xsd");
    }
}

