/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Iterables;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.remotable.plugin.ApplicationLinkAccessor;
import com.atlassian.plugin.remotable.plugin.OAuthLinkManager;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBDispatchFilter;
import com.atlassian.plugin.remotable.plugin.module.applinks.RemotePluginContainerModuleDescriptor;
import com.atlassian.plugin.remotable.plugin.util.function.MapFunctions;
import com.atlassian.plugin.remotable.plugin.util.http.CachingHttpContentRetriever;
import com.atlassian.plugin.remotable.plugin.util.http.ContentRetrievalException;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.RemotablePluginAccessor;
import com.atlassian.plugin.remotable.spi.RemotablePluginAccessorFactory;
import com.atlassian.plugin.remotable.spi.applinks.RemotePluginContainerApplicationType;
import com.atlassian.plugin.remotable.spi.http.AuthorizationGenerator;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DefaultRemotablePluginAccessorFactory
implements RemotablePluginAccessorFactory,
DisposableBean {
    private final ApplicationLinkAccessor applicationLinkAccessor;
    private final OAuthLinkManager oAuthLinkManager;
    private final CachingHttpContentRetriever httpContentRetriever;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final UBDispatchFilter ubDispatchFilter;
    private final EventPublisher eventPublisher;
    private final Map<String, RemotablePluginAccessor> accessors;

    @Autowired
    public DefaultRemotablePluginAccessorFactory(ApplicationLinkAccessor applicationLinkAccessor, OAuthLinkManager oAuthLinkManager, CachingHttpContentRetriever httpContentRetriever, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, UBDispatchFilter ubDispatchFilter, EventPublisher eventPublisher) {
        this.applicationLinkAccessor = applicationLinkAccessor;
        this.oAuthLinkManager = oAuthLinkManager;
        this.httpContentRetriever = httpContentRetriever;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.ubDispatchFilter = ubDispatchFilter;
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.accessors = CopyOnWriteMap.newHashMap();
    }

    @EventListener
    public void onApplicationLinkCreated(ApplicationLinkAddedEvent event) {
        if (event.getApplicationType() instanceof RemotePluginContainerApplicationType) {
            this.accessors.clear();
        }
    }

    @EventListener
    public void onApplicationLinkRemoved(ApplicationLinkDeletedEvent event) {
        if (event.getApplicationType() instanceof RemotePluginContainerApplicationType) {
            this.accessors.remove((String)event.getApplicationLink().getProperty("plugin-key"));
        }
    }

    public RemotablePluginAccessor get(String pluginKey) {
        boolean isRemotable;
        if (this.accessors.containsKey(pluginKey)) {
            return this.accessors.get(pluginKey);
        }
        ApplicationLink link = this.applicationLinkAccessor.getApplicationLink(pluginKey);
        boolean bl = isRemotable = !Iterables.findFirst(this.pluginAccessor.getPlugin(pluginKey).getModuleDescriptors(), new Predicate<ModuleDescriptor<?>>(){

            public boolean apply(@Nullable ModuleDescriptor<?> input) {
                return input instanceof RemotePluginContainerModuleDescriptor;
            }
        }).isEmpty();
        return this.create(pluginKey, link != null ? link.getDisplayUrl() : (isRemotable ? URI.create(this.ubDispatchFilter.getLocalMountBaseUrl(pluginKey)) : URI.create(this.applicationProperties.getBaseUrl())));
    }

    public RemotablePluginAccessor create(String pluginKey, URI displayUrl) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        Preconditions.checkNotNull((Object)plugin, (String)"Plugin not found: {}", (Object[])new Object[]{pluginKey});
        URI dummyUri = URI.create("http://localhost");
        ServiceProvider dummyProvider = new ServiceProvider(dummyUri, dummyUri, dummyUri);
        OAuthSigningRemotablePluginAccessor oAuthSigningRemotablePluginAccessor = new OAuthSigningRemotablePluginAccessor(pluginKey, plugin.getName(), displayUrl, dummyProvider);
        this.accessors.put(pluginKey, oAuthSigningRemotablePluginAccessor);
        return oAuthSigningRemotablePluginAccessor;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private String executeCreateGetUrl(URI targetUrl, Map<String, String[]> params) {
        return new UriBuilder(Uri.fromJavaUri(targetUrl)).addQueryParameters(Maps.transformValues(params, MapFunctions.STRING_ARRAY_TO_STRING)).toString();
    }

    private Promise<String> executeAsyncGetForType(AuthorizationGenerator authorizationGenerator, URI targetUrl, String username, Map<String, String> params, Map<String, String> headers, String pluginKey) {
        return this.httpContentRetriever.getAsync(authorizationGenerator, username, targetUrl, Maps.transformValues(params, MapFunctions.OBJECT_TO_STRING), headers, pluginKey);
    }

    private String signGetUrlForType(ServiceProvider serviceProvider, URI targetUrl, Map<String, String[]> params) throws PermissionDeniedException {
        UriBuilder uriBuilder = new UriBuilder(Uri.fromJavaUri(targetUrl));
        for (Map.Entry<String, String> param : this.signRequest(serviceProvider, targetUrl, params, "GET")) {
            String value = param.getValue() == null ? "" : param.getValue();
            uriBuilder.addQueryParameter(param.getKey(), value);
        }
        return uriBuilder.toString();
    }

    private URI getTargetUrl(URI displayUrl, URI targetPath) {
        return URI.create(displayUrl.toString() + targetPath.getPath());
    }

    private List<Map.Entry<String, String>> signRequest(ServiceProvider serviceProvider, URI url, Map<String, String[]> queryParams, String method) {
        String timestamp = System.currentTimeMillis() / 1000L + "";
        String nonce = System.nanoTime() + "";
        String signatureMethod = "RSA-SHA1";
        String oauthVersion = "1.0";
        HashMap params = Maps.newHashMap((Map)Maps.transformValues(queryParams, (Function)new Function<String[], List<String>>(){

            public List<String> apply(String[] from) {
                return Arrays.asList(from);
            }
        }));
        params.put("oauth_signature_method", Collections.singletonList(signatureMethod));
        params.put("oauth_nonce", Collections.singletonList(nonce));
        params.put("oauth_version", Collections.singletonList(oauthVersion));
        params.put("oauth_timestamp", Collections.singletonList(timestamp));
        return this.oAuthLinkManager.signAsParameters(serviceProvider, method, url, params);
    }

    private class OAuthAuthorizationGenerator
    implements AuthorizationGenerator {
        private final ServiceProvider serviceProvider;

        private OAuthAuthorizationGenerator(ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public String generate(String method, URI url, Map<String, List<String>> parameters) {
            return DefaultRemotablePluginAccessorFactory.this.oAuthLinkManager.generateAuthorizationHeader(method, this.serviceProvider, url, parameters);
        }
    }

    private class OAuthSigningRemotablePluginAccessor
    implements RemotablePluginAccessor {
        private final String key;
        private final String name;
        private final URI displayUrl;
        private final ServiceProvider serviceProvider;

        private OAuthSigningRemotablePluginAccessor(String key, String name, URI displayUrl, ServiceProvider serviceProvider) {
            this.key = key;
            this.name = name;
            this.displayUrl = displayUrl;
            this.serviceProvider = serviceProvider;
        }

        public String getKey() {
            return this.key;
        }

        public URI getDisplayUrl() {
            return this.displayUrl;
        }

        public String signGetUrl(URI targetPath, Map<String, String[]> params) {
            return DefaultRemotablePluginAccessorFactory.this.signGetUrlForType(this.serviceProvider, DefaultRemotablePluginAccessorFactory.this.getTargetUrl(this.displayUrl, targetPath), params);
        }

        public String createGetUrl(URI targetPath, Map<String, String[]> params) {
            return DefaultRemotablePluginAccessorFactory.this.executeCreateGetUrl(DefaultRemotablePluginAccessorFactory.this.getTargetUrl(this.displayUrl, targetPath), params);
        }

        public Promise<String> executeAsyncGet(String username, URI path, Map<String, String> params, Map<String, String> headers) throws ContentRetrievalException {
            return DefaultRemotablePluginAccessorFactory.this.executeAsyncGetForType(new OAuthAuthorizationGenerator(this.serviceProvider), DefaultRemotablePluginAccessorFactory.this.getTargetUrl(this.displayUrl, path), username, params, headers, this.key);
        }

        public AuthorizationGenerator getAuthorizationGenerator() {
            return new OAuthAuthorizationGenerator(this.serviceProvider);
        }

        public String getName() {
            return this.name;
        }
    }
}

