/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.remotable.plugin.UserPreferencesRetriever;
import com.atlassian.plugin.remotable.plugin.license.LicenseRetriever;
import com.atlassian.plugin.remotable.plugin.module.IFrameHost;
import com.atlassian.plugin.remotable.plugin.module.page.PageInfo;
import com.atlassian.plugin.remotable.plugin.util.EncodingUtils;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.RemotablePluginAccessor;
import com.atlassian.plugin.remotable.spi.module.IFrameContext;
import com.atlassian.plugin.remotable.spi.module.IFrameRenderer;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class IFrameRendererImpl
implements IFrameRenderer {
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final IFrameHost iframeHost;
    private final Plugin plugin;
    private final LicenseRetriever licenseRetriever;
    private final UserPreferencesRetriever userPreferencesRetriever;

    @Autowired
    public IFrameRendererImpl(TemplateRenderer templateRenderer, WebResourceManager webResourceManager, IFrameHost iframeHost, WebResourceUrlProvider webResourceUrlProvider, PluginRetrievalService pluginRetrievalService, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory, UserPreferencesRetriever userPreferencesRetriever, LicenseRetriever licenseRetriever) {
        this.licenseRetriever = licenseRetriever;
        this.userPreferencesRetriever = (UserPreferencesRetriever)Preconditions.checkNotNull((Object)userPreferencesRetriever);
        this.remotablePluginAccessorFactory = (DefaultRemotablePluginAccessorFactory)Preconditions.checkNotNull((Object)remotablePluginAccessorFactory);
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.webResourceManager = (WebResourceManager)Preconditions.checkNotNull((Object)webResourceManager);
        this.iframeHost = (IFrameHost)Preconditions.checkNotNull((Object)iframeHost);
        this.webResourceUrlProvider = (WebResourceUrlProvider)Preconditions.checkNotNull((Object)webResourceUrlProvider);
        this.plugin = ((PluginRetrievalService)Preconditions.checkNotNull((Object)pluginRetrievalService)).getPlugin();
    }

    public String render(IFrameContext iframeContext, String remoteUser) throws IOException {
        return this.render(iframeContext, "", Collections.<String, String[]>emptyMap(), remoteUser);
    }

    public void renderPage(IFrameContext iframeContext, PageInfo pageInfo, String extraPath, Map<String, String[]> queryParams, String remoteUser, Writer writer) throws IOException {
        try {
            if (!pageInfo.getCondition().shouldDisplay(Collections.emptyMap())) {
                throw new PermissionDeniedException(iframeContext.getPluginKey(), "Cannot render iframe for this page");
            }
            HashMap ctx = Maps.newHashMap((Map)iframeContext.getIFrameParams().getAsMap());
            if (queryParams.get("width") != null) {
                iframeContext.getIFrameParams().setParam("width", queryParams.get("width")[0]);
            }
            if (queryParams.get("height") != null) {
                iframeContext.getIFrameParams().setParam("height", queryParams.get("height")[0]);
            }
            ctx.put("queryParams", this.contextQueryParameters(queryParams));
            ctx.put("title", pageInfo.getTitle());
            ctx.put("contextPath", this.iframeHost.getContextPath());
            ctx.put("iframeHtml", this.render(iframeContext, extraPath, queryParams, remoteUser));
            ctx.put("decorator", pageInfo.getDecorator());
            for (Map.Entry<String, String> metaTag : pageInfo.getMetaTagsContent().entrySet()) {
                ctx.put(metaTag.getKey(), metaTag.getValue());
            }
            this.templateRenderer.render("velocity/iframe-page" + pageInfo.getTemplateSuffix() + ".vm", (Map)ctx, writer);
        }
        catch (PermissionDeniedException ex) {
            this.templateRenderer.render("velocity/iframe-page-accessdenied" + pageInfo.getTemplateSuffix() + ".vm", (Map)ImmutableMap.of((Object)"title", (Object)pageInfo.getTitle(), (Object)"decorator", (Object)pageInfo.getDecorator()), writer);
        }
    }

    public String render(IFrameContext iframeContext, String extraPath, Map<String, String[]> queryParams, String remoteUser) throws IOException {
        this.webResourceManager.requireResourcesForContext("remotable-plugins-iframe");
        RemotablePluginAccessor remotablePluginAccessor = this.remotablePluginAccessorFactory.get(iframeContext.getPluginKey());
        URI hostUrl = this.iframeHost.getUrl();
        URI iframeUrl = URI.create(iframeContext.getIframePath().getPath() + ObjectUtils.toString((Object)extraPath));
        String[] dialog = queryParams.get("dialog");
        String timeZone = this.userPreferencesRetriever.getTimeZoneFor(remoteUser).getID();
        HashMap allParams = Maps.newHashMap(queryParams);
        allParams.put("user_id", new String[]{remoteUser});
        allParams.put("xdm_e", new String[]{hostUrl.toString()});
        allParams.put("xdm_c", new String[]{"channel-" + iframeContext.getNamespace()});
        allParams.put("xdm_p", new String[]{"1"});
        allParams.put("cp", new String[]{this.iframeHost.getContextPath()});
        allParams.put("tz", new String[]{timeZone});
        allParams.put("lic", new String[]{this.licenseRetriever.getLicenseStatus(this.plugin.getKey()).value()});
        if (dialog != null && dialog.length == 1) {
            allParams.put("dialog", dialog);
        }
        String signedUrl = remotablePluginAccessor.signGetUrl(iframeUrl, (Map)allParams);
        signedUrl = new UriBuilder(Uri.parse(signedUrl)).removeQueryParameter("xdm_e").removeQueryParameter("xdm_c").removeQueryParameter("xdm_p").toString();
        HashMap ctx = Maps.newHashMap((Map)iframeContext.getIFrameParams().getAsMap());
        ctx.put("iframeSrcHtml", EncodingUtils.escapeQuotes(signedUrl));
        ctx.put("plugin", remotablePluginAccessor);
        ctx.put("namespace", iframeContext.getNamespace());
        ctx.put("scriptUrls", this.getJavaScriptUrls());
        ctx.put("contextPath", this.iframeHost.getContextPath());
        ctx.put("userId", remoteUser == null ? "" : remoteUser);
        ctx.put("data", ImmutableMap.of((Object)"timeZone", (Object)timeZone));
        if (dialog != null && dialog.length == 1) {
            ctx.put("dialog", dialog[0]);
        }
        StringWriter output = new StringWriter();
        this.templateRenderer.render("velocity/iframe-body.vm", (Map)ctx, (Writer)output);
        return output.toString();
    }

    public List<String> getJavaScriptUrls() {
        ArrayList scripts = Lists.newArrayList();
        ModuleDescriptor moduleDescriptor = this.plugin.getModuleDescriptor("iframe-host-js");
        for (ResourceDescriptor descriptor : moduleDescriptor.getResourceDescriptors()) {
            String src = this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleDescriptor, descriptor.getName(), UrlMode.AUTO);
            if (!src.endsWith(".js")) continue;
            scripts.add(src);
        }
        return scripts;
    }

    private Map<String, List<String>> contextQueryParameters(Map<String, String[]> queryParams) {
        HashMap ctxQueryParams = Maps.newHashMap();
        for (Map.Entry<String, String[]> param : queryParams.entrySet()) {
            ctxQueryParams.put(param.getKey(), Arrays.asList((Object[])param.getValue()));
        }
        return ctxQueryParams;
    }
}

