/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.util.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ContentRetrievalErrors {
    private final List<String> messages;
    private final Map<String, String> fieldErrors;

    public ContentRetrievalErrors(List<String> message) {
        this(message, (Map<String, String>)ImmutableMap.of());
    }

    public ContentRetrievalErrors(List<String> messages, Map<String, String> fieldErrors) {
        this.messages = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(messages)));
        this.fieldErrors = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(fieldErrors)));
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public Map<String, String> getFieldErrors() {
        return this.fieldErrors;
    }

    public boolean hasErrors() {
        return !this.messages.isEmpty() || !this.fieldErrors.isEmpty();
    }

    static ContentRetrievalErrors fromJson(String errorsAsJson) {
        try {
            JSONObject errors = new JSONObject(errorsAsJson);
            ImmutableList.Builder messagesBuilder = ImmutableList.builder();
            if (errors.has("messages")) {
                JSONArray messages = errors.getJSONArray("messages");
                for (int i = 0; i < messages.length(); ++i) {
                    messagesBuilder.add((Object)messages.getString(i));
                }
            }
            ImmutableMap.Builder fieldErrorsBuilder = ImmutableMap.builder();
            if (errors.has("fields")) {
                JSONArray fieldErrors = errors.getJSONArray("fields");
                for (int i = 0; i < fieldErrors.length(); ++i) {
                    JSONObject fieldError = fieldErrors.getJSONObject(i);
                    fieldErrorsBuilder.put((Object)fieldError.getString("name"), (Object)fieldError.getString("message"));
                }
            }
            return new ContentRetrievalErrors((List<String>)messagesBuilder.build(), (Map<String, String>)fieldErrorsBuilder.build());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

