/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.loader;

import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.remotable.api.service.HttpResourceMounter;
import com.atlassian.plugin.remotable.api.service.RequestContext;
import com.atlassian.plugin.remotable.api.service.SignedRequestHandler;
import com.atlassian.plugin.remotable.host.common.service.AuthenticationFilter;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBDispatchFilter;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHttpResourceMounter
implements HttpResourceMounter {
    private final UBDispatchFilter httpResourceFilter;
    private static final Logger log = LoggerFactory.getLogger(LocalHttpResourceMounter.class);
    private final String appKey;

    public LocalHttpResourceMounter(Bundle bundle, UBDispatchFilter httpResourceFilter, SignedRequestHandler signedRequestHandler, RequestContext requestContext) {
        this.httpResourceFilter = httpResourceFilter;
        this.appKey = OsgiHeaderUtil.getPluginKey((Bundle)bundle);
        this.mountFilter(new AuthenticationFilter(signedRequestHandler, requestContext), "/*");
    }

    public String getLocalMountBaseUrl() {
        return this.httpResourceFilter.getLocalMountBaseUrl(this.appKey);
    }

    public void mountFilter(Filter filter, String ... urlPatterns) {
        this.httpResourceFilter.mountFilter(this.appKey, filter, urlPatterns);
    }

    public void mountServlet(HttpServlet httpServlet, String ... urlPatterns) {
        this.httpResourceFilter.mountServlet(this.appKey, httpServlet, urlPatterns);
    }

    public void mountStaticResources(String resourcePrefix, String urlPattern) {
        this.httpResourceFilter.mountResources(this.appKey, resourcePrefix, urlPattern);
    }
}

