/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.integration.plugins;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.integration.plugins.I18nPropertiesPluginManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicDescriptorRegistration {
    private final BundleContext bundleContext;
    private final I18nPropertiesPluginManager i18nPropertiesPluginManager;
    private static final Logger log = LoggerFactory.getLogger(DynamicDescriptorRegistration.class);

    @Autowired
    public DynamicDescriptorRegistration(BundleContext bundleContext, I18nPropertiesPluginManager i18nPropertiesPluginManager) {
        this.bundleContext = bundleContext;
        this.i18nPropertiesPluginManager = i18nPropertiesPluginManager;
    }

    public Registration registerDescriptors(Plugin plugin, DescriptorToRegister ... descriptors) {
        return this.registerDescriptors(plugin, Arrays.asList(descriptors));
    }

    public Registration registerDescriptors(Plugin plugin, Iterable<DescriptorToRegister> descriptors) {
        Bundle bundle = BundleUtil.findBundleForPlugin(this.bundleContext, plugin.getKey());
        BundleContext targetBundleContext = bundle.getBundleContext();
        final ArrayList registrations = Lists.newArrayList();
        for (DescriptorToRegister reg : descriptors) {
            ModuleDescriptor descriptor = reg.getDescriptor();
            ModuleDescriptor existingDescriptor = plugin.getModuleDescriptor(descriptor.getKey());
            if (existingDescriptor != null) {
                log.error("Duplicate key '" + descriptor.getKey() + "' detected, disabling previous instance");
                ((StateAware)existingDescriptor).disabled();
            }
            log.debug("Registering descriptor {}", (Object)descriptor.getClass().getName());
            registrations.add(targetBundleContext.registerService(ModuleDescriptor.class.getName(), (Object)descriptor, null));
            if (reg.getI18nProperties() == null) continue;
            this.i18nPropertiesPluginManager.add(plugin.getKey(), reg.getI18nProperties());
        }
        return new Registration(){

            @Override
            public void unregister() {
                for (ServiceRegistration reg : registrations) {
                    reg.unregister();
                }
            }
        };
    }

    public static interface Registration {
        public void unregister();
    }
}

