/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.OSWorkflowConfigurator;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.jira.workflow.RemoteWorkflowFunctionPluginFactory;
import com.atlassian.plugin.remotable.plugin.module.jira.workflow.RemoteWorkflowPostFunctionProvider;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.plugin.product.jira.JiraRestBeanMarshaler;
import com.atlassian.plugin.remotable.spi.module.IFrameContext;
import com.atlassian.plugin.remotable.spi.module.IFrameParams;
import com.atlassian.plugin.remotable.spi.module.IFrameRenderer;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webhooks.spi.provider.ConsumerKey;
import com.atlassian.webhooks.spi.provider.ModuleDescriptorWebHookConsumerRegistry;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class RemoteWorkflowPostFunctionModuleDescriptor
extends WorkflowFunctionModuleDescriptor {
    private static final String POST_FUNCTION_EXTRA_MARKUP = "velocity/jira/workflow/post-function-extra-markup.vm";
    private final ModuleDescriptorWebHookConsumerRegistry webHookConsumerRegistry;
    private final OSWorkflowConfigurator workflowConfigurator;
    private final IFrameRenderer iFrameRenderer;
    private final TypeResolver remoteWorkflowTypeResolver;
    private final TemplateRenderer templateRenderer;
    private Element descriptor;
    private Map<String, URI> workflowFunctionActionUris;
    private String moduleKey;
    private URI publishURI;

    public RemoteWorkflowPostFunctionModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, IFrameRenderer iFrameRenderer, final JiraRestBeanMarshaler jiraRestBeanMarshaler, ModuleDescriptorWebHookConsumerRegistry webHookConsumerRegistry, final EventPublisher eventPublisher, TemplateRenderer templateRenderer) {
        super(authenticationContext, (OSWorkflowConfigurator)ComponentAccessor.getComponent(OSWorkflowConfigurator.class), (ComponentClassManager)ComponentAccessor.getComponent(ComponentClassManager.class), moduleFactory);
        this.webHookConsumerRegistry = webHookConsumerRegistry;
        this.templateRenderer = templateRenderer;
        this.workflowConfigurator = (OSWorkflowConfigurator)ComponentAccessor.getComponent(OSWorkflowConfigurator.class);
        this.iFrameRenderer = iFrameRenderer;
        this.remoteWorkflowTypeResolver = new TypeResolver(){

            public FunctionProvider getFunction(String type, Map args) throws WorkflowException {
                return new RemoteWorkflowPostFunctionProvider(eventPublisher, jiraRestBeanMarshaler, new ConsumerKey(RemoteWorkflowPostFunctionModuleDescriptor.this.plugin.getKey(), RemoteWorkflowPostFunctionModuleDescriptor.this.moduleKey));
            }
        };
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        try {
            element.addElement(this.getParameterName()).addText(RemoteWorkflowPostFunctionProvider.class.getName());
            this.descriptor = element;
            this.moduleKey = Dom4jUtils.getRequiredAttribute((Element)element, (String)"key");
            this.publishURI = this.createURI(element);
            ImmutableMap.Builder workflowFunctionActionUrisMapBuilder = ImmutableMap.builder();
            if (this.descriptor.element("view") != null) {
                workflowFunctionActionUrisMapBuilder.put((Object)"view", (Object)this.iFrameURI("view"));
            }
            if (this.descriptor.element("create") != null) {
                workflowFunctionActionUrisMapBuilder.put((Object)"input-parameters", (Object)this.iFrameURI("input-parameters"));
            }
            if (this.descriptor.element("edit") != null) {
                workflowFunctionActionUrisMapBuilder.put((Object)"edit-parameters", (Object)this.iFrameURI("edit-parameters"));
            }
            this.workflowFunctionActionUris = workflowFunctionActionUrisMapBuilder.build();
            super.init(plugin, element);
            this.resources = this.createResourceDescriptors(this.workflowFunctionActionUris);
        }
        catch (URISyntaxException e) {
            throw new PluginParseException((Throwable)e);
        }
    }

    public void enabled() {
        this.workflowConfigurator.registerTypeResolver(RemoteWorkflowPostFunctionProvider.class.getName(), this.remoteWorkflowTypeResolver);
        this.webHookConsumerRegistry.register("remote_workflow_post_function", new ConsumerKey(this.plugin.getKey(), this.moduleKey), this.publishURI);
    }

    public void disabled() {
        this.workflowConfigurator.unregisterTypeResolver(RemoteWorkflowPostFunctionProvider.class.getName(), this.remoteWorkflowTypeResolver);
        this.webHookConsumerRegistry.unregister("remote_workflow_post_function", new ConsumerKey(this.plugin.getKey(), this.moduleKey), this.publishURI);
    }

    public void destroy(Plugin plugin) {
        this.disabled();
    }

    public String getHtml(String resourceName, @Nullable AbstractDescriptor functionDescriptor) {
        try {
            User loggedInUser = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
            Map params = this.getModule().getVelocityParams(resourceName, functionDescriptor);
            String uuid = (String)params.get("remoteWorkflowPostFunctionUUID");
            IFrameParams iFrameParams = this.createIFrameParams(params, uuid);
            String namespace = this.moduleKey + uuid;
            return this.iFrameRenderer.render((IFrameContext)new IFrameContextImpl(this.getPluginKey(), this.workflowFunctionActionUris.get(resourceName), namespace, iFrameParams), "", (Map)ImmutableMap.of((Object)"remoteWorkflowPostFunctionUUID", (Object)new String[]{uuid}), loggedInUser.getDisplayName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IFrameParams createIFrameParams(Map<String, ?> params, String uuid) throws IOException {
        IFrameParamsImpl iFrameParams = new IFrameParamsImpl(this.descriptor);
        String functionConfiguration = StringUtils.defaultString((String)((String)params.get("remoteWorkflowPostFunctionConfiguration")));
        ImmutableMap extraMarkupParams = ImmutableMap.of((Object)"remoteWorkflowPostFunctionConfiguration", (Object)functionConfiguration, (Object)"remoteWorkflowPostFunctionUUID", (Object)uuid);
        StringWriter writer = new StringWriter();
        this.templateRenderer.render(POST_FUNCTION_EXTRA_MARKUP, (Map)extraMarkupParams, (Writer)writer);
        iFrameParams.setParamNoEscape("extraMarkupHtml", writer.toString());
        return iFrameParams;
    }

    private URI iFrameURI(String resourceName) {
        try {
            if (resourceName.equals("view")) {
                return this.createURI(this.descriptor.element("view"));
            }
            if (resourceName.equals("input-parameters")) {
                return this.createURI(this.descriptor.element("create"));
            }
            return this.createURI(this.descriptor.element("edit"));
        }
        catch (URISyntaxException e) {
            throw new PluginParseException((Throwable)e);
        }
    }

    private URI createURI(Element element) throws URISyntaxException {
        return new URI(Dom4jUtils.getRequiredAttribute((Element)element, (String)"url"));
    }

    private Resources createResourceDescriptors(Map<String, URI> workflowFunctionActionUris) {
        Element root = DocumentFactory.getInstance().createDocument().addElement("resources");
        for (String resourceType : workflowFunctionActionUris.keySet()) {
            root.addElement("resource").addAttribute("name", resourceType).addAttribute("type", "velocity").addAttribute("location", "location");
        }
        return Resources.fromXml((Element)root);
    }

    public Class<WorkflowPluginFunctionFactory> getImplementationClass() {
        return RemoteWorkflowPostFunctionProvider.class;
    }

    public WorkflowPluginFunctionFactory getModule() {
        return new RemoteWorkflowFunctionPluginFactory();
    }

    public boolean isEditable() {
        return super.isEditable();
    }
}

