/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.jira;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.plugin.remotable.plugin.module.jira.workflow.RemoteWorkflowPostFunctionEvent;
import com.atlassian.plugin.remotable.plugin.product.jira.webhook.JiraEventSerializerFactory;
import com.atlassian.webhooks.spi.provider.ConsumerKey;
import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.WebHookProvider;
import com.atlassian.webhooks.spi.provider.WebHookRegistrar;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class JiraWebHookProvider
implements WebHookProvider {
    private final JiraEventSerializerFactory eventSerializerFactory;

    public JiraWebHookProvider(JiraEventSerializerFactory eventSerializerFactory) {
        this.eventSerializerFactory = eventSerializerFactory;
    }

    private Map<Long, String> buildIdentifierByEventTypeMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EventType.ISSUE_ASSIGNED_ID, (Object)"issue_assigned");
        builder.put((Object)EventType.ISSUE_CLOSED_ID, (Object)"issue_closed");
        builder.put((Object)EventType.ISSUE_CREATED_ID, (Object)"issue_created");
        builder.put((Object)EventType.ISSUE_REOPENED_ID, (Object)"issue_reopened");
        builder.put((Object)EventType.ISSUE_RESOLVED_ID, (Object)"issue_resolved");
        builder.put((Object)EventType.ISSUE_COMMENT_EDITED_ID, (Object)"issue_comment_edited");
        builder.put((Object)EventType.ISSUE_COMMENTED_ID, (Object)"issue_commented");
        builder.put((Object)EventType.ISSUE_DELETED_ID, (Object)"issue_deleted");
        builder.put((Object)EventType.ISSUE_MOVED_ID, (Object)"issue_moved");
        builder.put((Object)EventType.ISSUE_UPDATED_ID, (Object)"issue_updated");
        builder.put((Object)EventType.ISSUE_WORKLOG_DELETED_ID, (Object)"issue_worklog_deleted");
        builder.put((Object)EventType.ISSUE_WORKLOG_UPDATED_ID, (Object)"issue_worklog_updated");
        builder.put((Object)EventType.ISSUE_WORKLOGGED_ID, (Object)"issue_work_logged");
        builder.put((Object)EventType.ISSUE_WORKSTARTED_ID, (Object)"issue_work_started");
        builder.put((Object)EventType.ISSUE_WORKSTOPPED_ID, (Object)"issue_work_stopped");
        builder.put((Object)EventType.ISSUE_GENERICEVENT_ID, (Object)"issue_generic_event");
        return builder.build();
    }

    public void provide(WebHookRegistrar publish) {
        for (Map.Entry<Long, String> entry : this.buildIdentifierByEventTypeMap().entrySet()) {
            publish.webhook(entry.getValue()).whenFired(IssueEvent.class).matchedBy((EventMatcher)new EventTypeMatcher(entry.getKey())).serializedWith((EventSerializerFactory)this.eventSerializerFactory);
        }
        publish.webhook("remote_workflow_post_function").whenFired(RemoteWorkflowPostFunctionEvent.class).matchedBy((EventMatcher)new RemoteWorkflowPostFunctionEvent.FunctionEventMatcher()).serializedWith((EventSerializerFactory)new RemoteWorkflowPostFunctionEvent.FunctionEventSerializerFactory());
    }

    private static final class EventTypeMatcher
    implements EventMatcher<IssueEvent> {
        private final Long eventType;

        private EventTypeMatcher(Long eventType) {
            this.eventType = eventType;
        }

        public boolean matches(IssueEvent event, ConsumerKey consumerKey) {
            return this.eventType.equals(event.getEventTypeId());
        }
    }
}

