/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.jira;

import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.BigPipe;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Preconditions;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraBigPipeFooter
implements PluggableFooter {
    private final BigPipe bigPipe;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private static final Logger log = LoggerFactory.getLogger(JiraBigPipeFooter.class);

    public JiraBigPipeFooter(BigPipe bigPipe, WebResourceUrlProvider webResourceUrlProvider) {
        this.bigPipe = (BigPipe)Preconditions.checkNotNull((Object)bigPipe);
        this.webResourceUrlProvider = (WebResourceUrlProvider)Preconditions.checkNotNull((Object)webResourceUrlProvider);
    }

    public void init(FooterModuleDescriptor descriptor) {
    }

    public String getFullFooterHtml(HttpServletRequest request) {
        return this.getFooterHtml();
    }

    public String getSmallFooterHtml(HttpServletRequest request) {
        return this.getFooterHtml();
    }

    private String getFooterHtml() {
        String bigPipeJs = this.webResourceUrlProvider.getStaticPluginResourceUrl("com.atlassian.labs.remoteapps-plugin:big-pipe", "big-pipe.js", UrlMode.AUTO);
        String json = this.bigPipe.consumeContent();
        return "<script>(function(global) {var AP = global._AP = global._AP || {};if (AP.RemoteConditions) AP.RemoteConditions.hide();var contents = " + json + ";" + "if (AP.BigPipe) AP.BigPipe.processContents(contents);" + "else AJS.$.getScript('" + bigPipeJs + "')" + ".done(function(){AP.BigPipe.processContents(contents);});" + "})(this);" + "</script>";
    }
}

