/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.integration.speakeasy;

import com.atlassian.event.api.EventListener;
import com.atlassian.labs.speakeasy.descriptor.external.ConditionGenerator;
import com.atlassian.labs.speakeasy.descriptor.external.DescriptorGenerator;
import com.atlassian.labs.speakeasy.external.SpeakeasyBackendService;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.host.common.util.RemotablePluginManifestReader;
import com.google.common.base.Preconditions;
import java.util.Collections;
import org.dom4j.DocumentFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SpeakeasyEventListener {
    private final ModuleFactory moduleFactory;
    private final SpeakeasyBackendService speakeasyBackendService;
    private final BundleContext bundleContext;

    public SpeakeasyEventListener(ModuleFactory moduleFactory, BundleContext bundleContext, SpeakeasyBackendService speakeasyBackendService) {
        this.moduleFactory = (ModuleFactory)Preconditions.checkNotNull((Object)moduleFactory);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.speakeasyBackendService = (SpeakeasyBackendService)Preconditions.checkNotNull((Object)speakeasyBackendService);
    }

    @EventListener
    public void onAppStarted(PluginEnabledEvent event) {
        Bundle bundle = BundleUtil.findBundleForPlugin(this.bundleContext, event.getPlugin().getKey());
        if (bundle != null && RemotablePluginManifestReader.isRemotePlugin(bundle)) {
            this.makeAppVisibleInSpeakeasy(bundle, event.getPlugin());
        }
    }

    private void makeAppVisibleInSpeakeasy(Bundle bundle, Plugin plugin) {
        bundle.getBundleContext().registerService(ModuleDescriptor.class.getName(), (Object)new SpeakeasyMarkerModuleDescriptor(this.moduleFactory, plugin), null);
        if (!this.speakeasyBackendService.isGlobalExtension(plugin.getKey())) {
            this.speakeasyBackendService.addGlobalExtension(plugin.getKey());
        }
    }

    public static final class SpeakeasyMarkerModuleDescriptor
    extends AbstractModuleDescriptor
    implements DescriptorGenerator {
        public SpeakeasyMarkerModuleDescriptor(ModuleFactory moduleFactory, Plugin plugin) {
            super(moduleFactory);
            this.init(plugin, DocumentFactory.getInstance().createElement("marker").addAttribute("key", "__speakeasy_marker"));
        }

        public Object getModule() {
            return null;
        }

        public Iterable getDescriptorsToExposeForUsers(ConditionGenerator conditionGenerator, long l) {
            return Collections.emptyList();
        }
    }
}

