/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.iframe;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourcesFilter
implements Filter {
    public static final int PLUGIN_TTL_NEAR_FUTURE = 1800;
    public static final int AUI_TTL_FAR_FUTURE = 31536000;
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("(all(-debug)?\\.(js|css))|(aui/.*)");
    private static final Logger log = LoggerFactory.getLogger(StaticResourcesFilter.class);
    private static Plugin plugin;
    private final boolean devMode;
    private FilterConfig config;
    private Map<String, CacheEntry> cache;

    public StaticResourcesFilter(PluginRetrievalService pluginRetreivalService) {
        plugin = pluginRetreivalService.getPlugin();
        this.devMode = Boolean.getBoolean("atlassian.dev.mode");
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.cache = new MapMaker().makeComputingMap((Function)new Function<String, CacheEntry>(){

            public CacheEntry apply(String from) {
                return new CacheEntry(from);
            }
        });
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CacheEntry entry;
        String encoding;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String fullPath = req.getRequestURI().substring(req.getContextPath().length());
        if (!fullPath.startsWith("/remotable-plugins")) {
            this.send404(fullPath, res);
            return;
        }
        String localPath = fullPath.substring("/remotable-plugins".length() + 1);
        if (!RESOURCE_PATTERN.matcher(localPath).matches()) {
            this.send404(fullPath, res);
            return;
        }
        String allDebugJsPath = "all-debug.js";
        if ("all-debug.js".equals(localPath)) {
            encoding = "identity";
            String moduleDir = "js/iframe/";
            String[] modules = new String[]{"plugin-core.js", "rpc.js", "plugin-api.js"};
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (String module : modules) {
                bout.write(("/* " + module + " */\n").getBytes());
                InputStream in = plugin.getResourceAsStream("js/iframe/" + module);
                IOUtils.copy((InputStream)in, (OutputStream)bout);
                bout.write(10);
            }
            entry = new CacheEntry("all-debug.js", bout.toByteArray());
        } else {
            if (req.getHeader("Accept-Encoding").contains("gzip")) {
                localPath = localPath + ".gz";
                encoding = "gzip";
            } else {
                encoding = "identity";
            }
            entry = this.cache.get(localPath);
            if (entry.getData().length == 0) {
                this.send404(fullPath, res);
                return;
            }
        }
        res.setContentType(entry.getContentType());
        res.setHeader("ETag", entry.getEtag());
        res.setHeader("Vary", "Accept-Encoding");
        this.setCacheControl(res, entry.getTTLSeconds());
        res.setHeader("Connection", "keep-alive");
        String previousToken = req.getHeader("If-None-Match");
        if (previousToken != null && previousToken.equals(entry.getEtag())) {
            res.setStatus(304);
        } else {
            res.setStatus(200);
            res.setContentLength(entry.getData().length);
            res.setHeader("Content-Encoding", encoding);
            ServletOutputStream sos = res.getOutputStream();
            sos.write(entry.getData());
            sos.flush();
            sos.close();
        }
        if (this.devMode) {
            this.cache.remove(localPath);
        }
    }

    private void setCacheControl(HttpServletResponse res, int ttl) {
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        res.setDateHeader("Date", cal.getTimeInMillis());
        cal.add(13, ttl);
        res.setHeader("Cache-Control", "public, max-age=" + ttl);
        res.setDateHeader("Expires", cal.getTime().getTime());
    }

    private void send404(String path, HttpServletResponse res) throws IOException {
        res.sendError(404, "Cannot find resource: " + path);
    }

    public void destroy() {
        this.cache.clear();
    }

    private class CacheEntry {
        private String contentType;
        private byte[] data;
        private String etag;
        private int ttl;

        public CacheEntry(String path, byte[] data) {
            this.setContentType(path);
            this.setData(data);
        }

        public CacheEntry(String path) {
            boolean gzip = path.endsWith(".gz");
            if (gzip) {
                path = path.substring(0, path.length() - 3);
            }
            this.setContentType(path);
            try {
                InputStream in = plugin.getResourceAsStream(path);
                if (in == null) {
                    this.clear();
                } else if (gzip) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    GZIPOutputStream out = new GZIPOutputStream(bytes);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.finish();
                    out.close();
                    this.setData(bytes.toByteArray());
                } else {
                    this.setData(IOUtils.toByteArray((InputStream)in));
                }
            }
            catch (IOException e) {
                log.error("Unable to retrieve content: " + path, (Throwable)e);
                this.clear();
            }
            this.ttl = path.startsWith("aui/") ? 31536000 : 1800;
        }

        private void setContentType(String path) {
            this.contentType = StaticResourcesFilter.this.config.getServletContext().getMimeType(path);
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            }
        }

        private void setData(byte[] data) {
            this.data = data;
            this.etag = DigestUtils.md5Hex((byte[])data);
        }

        public String getEtag() {
            return this.etag;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getContentType() {
            return this.contentType;
        }

        public int getTTLSeconds() {
            return this.ttl;
        }

        private void clear() {
            this.data = new byte[0];
            this.etag = "";
        }
    }
}

