/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http.bigpipe;

import com.atlassian.plugin.remotable.api.service.RequestContext;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.BigPipe;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.HtmlPromise;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.ContentEnvelopePromise;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.MetadataProvider;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.RequestIdAccessor;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.security.random.SecureRandomFactory;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.atlassian.util.concurrent.ForwardingPromise;
import com.atlassian.util.concurrent.Promise;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;

public final class BigPipeImpl
implements BigPipe,
DisposableBean {
    private static final SecureRandom secureRandom = SecureRandomFactory.newInstance();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WebResourceManager webResourceManager;
    private final RequestIdAccessor requestIdAccessor = new RequestIdAccessor();
    private final UserIdRetriever userIdRetriever;
    ScheduledExecutorService cleanupThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("Big Pipe Cleanup");
            return t;
        }
    });
    private final Map<String, RequestContentSet> requestContentSets = CopyOnWriteMap.newHashMap();

    BigPipeImpl(WebResourceManager webResourceManager, final RequestContext requestContext) {
        this(webResourceManager, new UserIdRetriever(){

            @Override
            public String getUserId() {
                return requestContext.getUserId();
            }
        });
    }

    @Autowired
    public BigPipeImpl(WebResourceManager webResourceManager, final UserManager userManager) {
        this(webResourceManager, new UserIdRetriever(){

            @Override
            public String getUserId() {
                return userManager.getRemoteUsername();
            }
        });
    }

    private BigPipeImpl(WebResourceManager webResourceManager, UserIdRetriever userIdRetriever) {
        this.webResourceManager = webResourceManager;
        this.userIdRetriever = userIdRetriever;
        this.cleanupThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BigPipeImpl.this.cleanExpiredRequests();
            }
        }, 2L, 1L, TimeUnit.MINUTES);
    }

    private void cleanExpiredRequests() {
        for (RequestContentSet contentSet : this.requestContentSets.values()) {
            if (!contentSet.isExpired()) continue;
            contentSet.removeRequestContentSet();
        }
    }

    public String getRequestId() {
        return this.requestIdAccessor.getRequestId();
    }

    public RequestIdAccessor getRequestIdAccessor() {
        return this.requestIdAccessor;
    }

    public HtmlPromise promiseHtmlContent(Promise<String> stringPromise) {
        DefaultHtmlPromise htmlPromise = new DefaultHtmlPromise(stringPromise);
        InternalHandler handler = this.registerContentPromise("html", (Promise<String>)htmlPromise);
        htmlPromise.setHandler(handler);
        return htmlPromise;
    }

    public void promiseContent(String channelId, Promise<String> stringPromise) {
        this.registerContentPromise(channelId, stringPromise);
    }

    private InternalHandler registerContentPromise(String channelId, Promise<String> stringPromise) {
        ContentEnvelopePromise envelopePromise = new ContentEnvelopePromise(stringPromise, channelId);
        this.webResourceManager.requireResource("com.atlassian.labs.remoteapps-plugin:big-pipe");
        String requestId = this.getRequestId();
        RequestContentSet requestContentSet = this.requestContentSets.get(requestId);
        if (requestContentSet == null) {
            requestContentSet = new RequestContentSet(requestId, this.userIdRetriever.getUserId());
            this.requestContentSets.put(requestId, requestContentSet);
        }
        final RequestContentSet finalRequestContentSet = requestContentSet;
        envelopePromise.then((FutureCallback)new FutureCallback<JSONObject>(){

            public void onSuccess(JSONObject json) {
                finalRequestContentSet.notifyConsumers();
            }

            public void onFailure(Throwable t) {
                finalRequestContentSet.notifyConsumers();
            }
        });
        InternalHandler handler = new InternalHandler(channelId, requestContentSet, envelopePromise);
        requestContentSet.addHandler(handler);
        return handler;
    }

    public String consumeContent() {
        Map<String, Collection<JSONObject>> finished;
        String requestId = this.getRequestId();
        RequestContentSet request = this.requestContentSets.get(requestId);
        if (request != null) {
            String userId = this.userIdRetriever.getUserId();
            finished = request.consumeFinishedContent(userId);
        } else {
            finished = Collections.emptyMap();
        }
        return this.convertContentToJson(finished, requestId);
    }

    public String waitForContent(String requestId) {
        Map<String, Collection<JSONObject>> finished;
        RequestContentSet request = this.requestContentSets.get(requestId);
        if (request != null) {
            String userId = this.userIdRetriever.getUserId();
            finished = request.waitForFinishedContent(userId);
        } else {
            finished = Collections.emptyMap();
        }
        return this.convertContentToJson(finished, requestId);
    }

    public boolean isActivated() {
        return this.requestContentSets.containsKey(this.getRequestId());
    }

    public void destroy() throws Exception {
        this.cleanupThread.shutdownNow();
    }

    private String convertContentToJson(Map<String, Collection<JSONObject>> contentByChannel, String requestId) {
        JSONObject response = new JSONObject();
        JSONArray items = new JSONArray();
        for (Collection<JSONObject> collection : contentByChannel.values()) {
            for (JSONObject json : collection) {
                items.add((Object)json);
            }
        }
        response.put((Object)"items", (Object)items);
        RequestContentSet requestContentSet = this.requestContentSets.get(requestId);
        JSONArray pendingChannelsArray = new JSONArray();
        Set<Object> pendingChannels = requestContentSet != null ? requestContentSet.getPendingChannelIds() : Sets.newHashSet();
        pendingChannelsArray.addAll((Collection)pendingChannels);
        response.put((Object)"pending", (Object)pendingChannelsArray);
        return response.toString();
    }

    static /* synthetic */ SecureRandom access$500() {
        return secureRandom;
    }

    private class DefaultHtmlPromise
    extends ForwardingPromise<String>
    implements HtmlPromise,
    MetadataProvider {
        private final Promise<String> delegate;
        private final String contentId = "bp-" + Long.toHexString(Math.abs(BigPipeImpl.access$500().nextLong()));
        private InternalHandler handler;

        public DefaultHtmlPromise(Promise<String> delegate) {
            this.delegate = delegate;
        }

        public String getInitialContent() {
            if (this.delegate().isDone()) {
                String content = (String)this.delegate().claim();
                this.handler.removeContent();
                return "<span id=\"" + this.contentId + "\">" + content + "</span>";
            }
            return "<span id=\"" + this.contentId + "\" class=\"bp-loading\"></span>";
        }

        @Override
        public Map<String, String> getMetadata() {
            return Collections.singletonMap("contentId", this.contentId);
        }

        protected Promise<String> delegate() {
            return this.delegate;
        }

        public void setHandler(InternalHandler handler) {
            this.handler = handler;
        }
    }

    private class RequestContentSet {
        private final List<InternalHandler> handlers = new CopyOnWriteArrayList<InternalHandler>();
        private final long expiry;
        private final String requestId;
        private final String userId;
        private final Object lock = new Object();

        public RequestContentSet(String requestId, String userId) {
            this.requestId = requestId;
            this.userId = userId;
            this.expiry = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        }

        public InternalHandler addHandler(InternalHandler handler) {
            this.handlers.add(handler);
            return handler;
        }

        public void removeContent(InternalHandler handler) {
            this.handlers.remove(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Collection<JSONObject>> consumeFinishedContent(String userId) {
            this.verifyUser(userId);
            ArrayListMultimap result = ArrayListMultimap.create();
            Object object = this.lock;
            synchronized (object) {
                if (this.handlers.isEmpty()) {
                    return Collections.emptyMap();
                }
                this.removeAllFinishedHandlers((Multimap<String, JSONObject>)result);
                if (!this.hasMoreContent()) {
                    BigPipeImpl.this.log.info("All content has been consumed for request id {}", (Object)this.requestId);
                    this.removeRequestContentSet();
                }
            }
            return result.asMap();
        }

        private void removeRequestContentSet() {
            this.handlers.clear();
            BigPipeImpl.this.requestContentSets.remove(this.requestId);
        }

        private boolean hasMoreContent() {
            return !this.handlers.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Collection<JSONObject>> waitForFinishedContent(String userId) {
            this.verifyUser(userId);
            ArrayListMultimap result = ArrayListMultimap.create();
            Object object = this.lock;
            synchronized (object) {
                if (this.handlers.isEmpty()) {
                    return Collections.emptyMap();
                }
                this.removeAllFinishedHandlers((Multimap<String, JSONObject>)result);
                if (result.isEmpty() && !this.isExpired()) {
                    try {
                        long timeout = this.expiry - System.currentTimeMillis();
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                        }
                        this.removeAllFinishedHandlers((Multimap<String, JSONObject>)result);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (this.isExpired()) {
                BigPipeImpl.this.log.info("Timeout waiting for {} jobs for request id {}", (Object)this.handlers.size(), (Object)this.requestId);
                this.removeRequestContentSet();
            }
            return result.asMap();
        }

        private void verifyUser(String userId) {
            if (userId == null ? this.userId != null : !userId.equals(this.userId)) {
                throw new RuntimeException("Current user is not authorized to access requested bigpipe content");
            }
        }

        private void removeAllFinishedHandlers(Multimap<String, JSONObject> result) {
            for (InternalHandler handler : Sets.newHashSet(this.handlers)) {
                if (!handler.isFinished()) continue;
                this.removeContent(handler);
                result.put((Object)handler.getChannelId(), handler.getContent().claim());
            }
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expiry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyConsumers() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        public Set<String> getPendingChannelIds() {
            HashSet pendingChannelIds = Sets.newHashSet();
            for (InternalHandler handler : this.handlers) {
                pendingChannelIds.add(handler.getChannelId());
            }
            return Collections.unmodifiableSet(pendingChannelIds);
        }
    }

    private class InternalHandler {
        private final String channelId;
        private final RequestContentSet request;
        private final Promise<JSONObject> jsonPromise;

        public InternalHandler(String channelId, RequestContentSet requestContentSet, Promise<JSONObject> jsonPromise) {
            this.channelId = channelId;
            this.request = requestContentSet;
            this.jsonPromise = jsonPromise.then((FutureCallback)new FutureCallback<JSONObject>(){

                public void onSuccess(JSONObject json) {
                    InternalHandler.this.request.notifyConsumers();
                }

                public void onFailure(Throwable t) {
                    InternalHandler.this.request.notifyConsumers();
                }
            });
        }

        public String getChannelId() {
            return this.channelId;
        }

        public Promise<JSONObject> getContent() {
            return this.jsonPromise;
        }

        public boolean isFinished() {
            return this.jsonPromise.isDone();
        }

        public void removeContent() {
            this.request.removeContent(this);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static interface UserIdRetriever {
        public String getUserId();
    }
}

