/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthServiceProvider;
import net.oauth.OAuthValidator;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOauthSignedRequestHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public String validateRequest(HttpServletRequest req) throws ServletException {
        URI requestUri = URI.create(req.getRequestURI());
        String url = this.getFullUrl(req);
        if (requestUri.getFragment() != null) {
            url = url + "#" + requestUri.getFragment();
        }
        if (req.getHeader("Authorization") != null) {
            OAuthMessage message = OAuthServlet.getMessage(req, url);
            return this.validateAndExtractKey(message);
        }
        OAuthMessage message = new OAuthMessage(req.getMethod(), url, this.convertToSingleValues(url, this.getRequestParameters(req)).entrySet());
        return this.validateAndExtractKey(message);
    }

    private OAuthConsumer getHostConsumer(String key) {
        String baseUrl = this.getHostBaseUrl(key);
        OAuthServiceProvider serviceProvider = new OAuthServiceProvider(baseUrl + "/plugins/servlet/oauth/request-token", baseUrl + "/plugins/servlet/oauth/authorize", baseUrl + "/plugins/servlet/oauth/access-token");
        OAuthConsumer host = new OAuthConsumer(null, key, null, serviceProvider);
        host.setProperty("RSA-SHA1.PublicKey", this.getHostOauthPublicKey(key));
        return host;
    }

    private String getFullUrl(HttpServletRequest req) {
        String contextPath = URI.create(this.getLocalBaseUrl()).getPath();
        String url = req.getRequestURI();
        if (url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        url = this.getLocalBaseUrl() + url;
        return url;
    }

    private Map<String, String[]> getRequestParameters(HttpServletRequest req) {
        return req.getParameterMap();
    }

    private Map<String, String> convertToSingleValues(String url, Map<String, String[]> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String[]> param : params.entrySet()) {
            if (param.getValue().length > 1) {
                throw new IllegalArgumentException(String.format("Must not have multiples of query parameters.\nFound issue for URL %s, and parameter %s, with values %s", url, param.getKey(), Arrays.toString(param.getValue())));
            }
            result.put(param.getKey(), param.getValue()[0]);
        }
        return result;
    }

    private String validateAndExtractKey(OAuthMessage message) throws ServletException {
        this.printMessage(message);
        try {
            OAuthConsumer host = this.getHostConsumer(message.getConsumerKey());
            message.validateMessage(new OAuthAccessor(host), (OAuthValidator)new SimpleOAuthValidator());
            return message.getConsumerKey();
        }
        catch (OAuthProblemException ex) {
            StringBuilder sb = new StringBuilder();
            sb.append("Validation failed: \n");
            sb.append("problem: ").append(ex.getProblem()).append("\n");
            sb.append("parameters: ").append(ex.getParameters()).append("\n");
            System.err.println(sb.toString());
            throw new ServletException((Throwable)ex);
        }
        catch (OAuthException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void printMessage(OAuthMessage message) {
        StringBuilder sb = new StringBuilder("Validating incoming OAuth request for remote plugin:\n");
        sb.append("\turl: ").append(message.URL.toString()).append("\n");
        sb.append("\tmethod: ").append(message.method.toString()).append("\n");
        try {
            for (Map.Entry entry : message.getParameters()) {
                sb.append("\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.log.debug(sb.toString());
    }

    public void sign(URI uri, String method, String username, HttpURLConnection yc) {
        String authorization = this.getAuthorizationHeaderValue(uri, method, username);
        yc.setRequestProperty("Authorization", authorization);
    }

    protected abstract String getAuthorizationHeaderValue(URI var1, String var2, String var3);

    protected abstract String getLocalBaseUrl();

    protected abstract Object getHostOauthPublicKey(String var1);

    protected abstract String getHostBaseUrl(String var1);
}

