package com.atlassian.plugins.license.entity;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;
import java.util.StringJoiner;

public class DirectoryInformationEntity {

    @JsonProperty("localDirectoryId")
    private final Long localDirectoryId;

    @JsonProperty("crowdDirectoryId")
    private final Long crowdDirectoryId;

    @JsonProperty("localDirectoryName")
    private final String localDirectoryName;

    @JsonProperty("remoteCrowdDirectory")
    private final boolean remoteCrowdDirectory;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    @JsonCreator
    public DirectoryInformationEntity(@JsonProperty("localDirectoryId") Long localDirectoryId, @JsonProperty("crowdDirectoryId") Long crowdDirectoryId,
                                      @JsonProperty("localDirectoryName") String localDirectoryName, @JsonProperty("remoteCrowdDirectory") boolean remoteCrowdDirectory) {
        this.localDirectoryId = localDirectoryId;
        this.crowdDirectoryId = crowdDirectoryId;
        this.localDirectoryName = localDirectoryName;
        this.remoteCrowdDirectory = remoteCrowdDirectory;
    }

    public Long getLocalDirectoryId() {
        return localDirectoryId;
    }

    public Long getCrowdDirectoryId() {
        return crowdDirectoryId;
    }

    public String getLocalDirectoryName() {
        return localDirectoryName;
    }

    public boolean isRemoteCrowdDirectory() {
        return remoteCrowdDirectory;
    }

    public static DirectoryInformationEntity.Builder builder() {
        return new DirectoryInformationEntity.Builder();
    }

    public static DirectoryInformationEntity.Builder builder(DirectoryInformationEntity data) {
        return new DirectoryInformationEntity.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DirectoryInformationEntity that = (DirectoryInformationEntity) o;

        return Objects.equals(this.getLocalDirectoryId(), that.getLocalDirectoryId()) && Objects.equals(this.getCrowdDirectoryId(), that.getCrowdDirectoryId()) && Objects.equals(this.getLocalDirectoryName(), that.getLocalDirectoryName()) && Objects.equals(this.isRemoteCrowdDirectory(), that.isRemoteCrowdDirectory());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getLocalDirectoryId(), getCrowdDirectoryId(), getLocalDirectoryName(), isRemoteCrowdDirectory());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]")
                .add("localDirectoryId=" + getLocalDirectoryId())
                .add("crowdDirectoryId=" + getCrowdDirectoryId())
                .add("localDirectoryName=" + getLocalDirectoryName())
                .add("remoteCrowdDirectory=" + isRemoteCrowdDirectory())
                .toString();
    }

    public static final class Builder {

        private Long localDirectoryId;
        private Long crowdDirectoryId;
        private String localDirectoryName;
        private boolean remoteCrowdDirectory;

        private Builder() {
        }

        private Builder(DirectoryInformationEntity initialData) {
            this.localDirectoryId = initialData.getLocalDirectoryId();
            this.crowdDirectoryId = initialData.getCrowdDirectoryId();
            this.localDirectoryName = initialData.getLocalDirectoryName();
            this.remoteCrowdDirectory = initialData.isRemoteCrowdDirectory();
        }

        public Builder setLocalDirectoryId(Long localDirectoryId) {
            this.localDirectoryId = localDirectoryId;
            return this;
        }

        public Builder setCrowdDirectoryId(Long crowdDirectoryId) {
            this.crowdDirectoryId = crowdDirectoryId;
            return this;
        }

        public Builder setLocalDirectoryName(String localDirectoryName) {
            this.localDirectoryName = localDirectoryName;
            return this;
        }

        public Builder setRemoteCrowdDirectory(boolean remoteCrowdDirectory) {
            this.remoteCrowdDirectory = remoteCrowdDirectory;
            return this;
        }

        public DirectoryInformationEntity build() {
            return new DirectoryInformationEntity(localDirectoryId, crowdDirectoryId, localDirectoryName, remoteCrowdDirectory);
        }
    }
}
