/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.domain.search;

import com.atlassian.plugins.domain.model.category.CategoryType;
import com.atlassian.plugins.domain.model.plugin.PluginStatus;
import com.atlassian.plugins.domain.model.plugin.PluginVersionStatus;
import com.atlassian.plugins.domain.model.review.ReviewStatus;
import com.atlassian.plugins.domain.search.SearchOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchCriteria {
    public static final String ENTITY_PREFIX = "x";
    public static final String COLLECTION = "[]";
    private static final String COLLECTION_PREFIX = "c";
    private Integer maxResults;
    private Integer offset;
    private boolean distinct = false;
    @XmlElement
    private final List<SearchExpression> expressions = new LinkedList<SearchExpression>();
    private String[] orderBy;
    protected static final String AND = "AND";
    protected static final String OR = "OR";

    public SearchCriteria() {
        this(null, null);
    }

    public SearchCriteria(Integer maxResults, Integer offest) {
        this.maxResults = maxResults;
        this.offset = offest;
    }

    public String toString() {
        return this.selectString("<ENTITY>", true);
    }

    public List<Object> getValues() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (SearchExpression ex : this.expressions) {
            if (ex.getCriteria() != null) {
                list.addAll(ex.getCriteria().getValues());
                continue;
            }
            if (!ex.getOperation().isSubstituted()) continue;
            if (ex.getValue() instanceof Collection) {
                list.addAll((Collection)ex.getValue());
                continue;
            }
            list.add(ex.getValue());
        }
        return list;
    }

    public String countString(String entity) {
        return this.doString(entity, true, true, 1);
    }

    public String selectString(String entity) {
        return this.doString(entity, true, false, 1);
    }

    public String selectString(String entity, boolean doPrefix) {
        return this.doString(entity, doPrefix, false, 1);
    }

    private String doString(String entity, boolean doPrefix, boolean count, int collection) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer joinBuffer = new StringBuffer();
        for (SearchExpression expression : this.expressions) {
            if (buffer.length() > 0) {
                buffer.append(" ");
                buffer.append(expression.getType());
                buffer.append(" ");
            }
            if (expression.getCriteria() != null) {
                String subcriteria = expression.getCriteria().doString(entity, false, false, ++collection);
                if (subcriteria.contains("LEFT OUTER JOIN")) {
                    String[] joinstring = subcriteria.split("LEFT OUTER JOIN");
                    joinBuffer.append(" LEFT OUTER JOIN");
                    joinBuffer.append(joinstring[1]);
                    subcriteria = joinstring[0];
                }
                buffer.append("(");
                buffer.append(subcriteria);
                buffer.append(")");
                if (!expression.getCriteria().isDistinct() || this.distinct) continue;
                this.distinct = true;
                continue;
            }
            if (expression.getFieldname().contains(COLLECTION)) {
                String[] components = expression.getFieldname().split("\\[\\]", 2);
                joinBuffer.append(" LEFT OUTER JOIN ");
                joinBuffer.append(ENTITY_PREFIX);
                joinBuffer.append(".");
                joinBuffer.append(components[0]);
                joinBuffer.append(" ");
                joinBuffer.append(COLLECTION_PREFIX + collection);
                if (expression.getFunction() == null) {
                    buffer.append(COLLECTION_PREFIX + collection);
                    buffer.append(components[1]);
                } else {
                    buffer.append(expression.getFunction());
                    buffer.append("(");
                    buffer.append(COLLECTION_PREFIX + collection);
                    buffer.append(components[1]);
                    buffer.append(")");
                }
            } else if (expression.getFunction() != null) {
                buffer.append(expression.getFunction());
                buffer.append("(");
                buffer.append(ENTITY_PREFIX);
                buffer.append(".");
                buffer.append(expression.getFieldname());
                buffer.append(")");
            } else {
                buffer.append(ENTITY_PREFIX);
                buffer.append(".");
                buffer.append(expression.getFieldname());
            }
            buffer.append(" ");
            buffer.append(expression.getOperation().getOperation());
            if (!expression.getOperation().isSubstituted()) continue;
            if (expression.getValue() instanceof Collection) {
                Collection coll = (Collection)expression.getValue();
                if (coll.size() <= 0) continue;
                buffer.append(" (");
                for (int i = 0; i < coll.size(); ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append("?");
                }
                buffer.append(")");
                continue;
            }
            buffer.append(" ?");
        }
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        if (doPrefix) {
            boolean doDistinct = this.distinct;
            if (count) {
                if (doDistinct) {
                    prefix.append("SELECT count(DISTINCT ");
                    prefix.append(ENTITY_PREFIX);
                    prefix.append(".id) FROM ");
                } else {
                    prefix.append("SELECT count(*) FROM ");
                }
            } else {
                if (this.orderBy != null) {
                    for (String field : this.orderBy) {
                        if (!field.contains(".")) continue;
                        doDistinct = false;
                        break;
                    }
                }
                prefix.append("SELECT ");
                if (doDistinct) {
                    prefix.append("DISTINCT ");
                }
                prefix.append(ENTITY_PREFIX);
                prefix.append(" FROM ");
                if (this.orderBy != null && this.orderBy.length > 0) {
                    for (String field : this.orderBy) {
                        if (suffix.length() > 0) {
                            suffix.append(", ");
                        }
                        suffix.append(ENTITY_PREFIX);
                        suffix.append(".");
                        suffix.append(field);
                    }
                    suffix.insert(0, " ORDER BY ");
                }
            }
            prefix.append(entity);
            prefix.append(" ");
            prefix.append(ENTITY_PREFIX);
            if (joinBuffer.length() > 0) {
                prefix.append(joinBuffer);
            }
            if (!this.expressions.isEmpty()) {
                prefix.append(" WHERE ");
            }
        } else if (joinBuffer.length() > 0) {
            suffix.append(joinBuffer);
        }
        return prefix.toString() + buffer.toString() + suffix.toString();
    }

    public SearchCriteria where(String fieldName, SearchOperation operation, Object value, String function) {
        return this.and(fieldName, operation, value, function);
    }

    public SearchCriteria and(String fieldName, SearchOperation operation, Object value, String function) {
        this.expressions.add(new SearchExpression(AND, fieldName, operation, value, function));
        return this;
    }

    public SearchCriteria or(String fieldName, SearchOperation operation, Object value, String function) {
        this.expressions.add(new SearchExpression(OR, fieldName, operation, value, function));
        return this;
    }

    public SearchCriteria where(String fieldName, SearchOperation operation, Object value) {
        return this.where(fieldName, operation, value, null);
    }

    public SearchCriteria and(String fieldName, SearchOperation operation, Object value) {
        return this.and(fieldName, operation, value, null);
    }

    public SearchCriteria or(String fieldName, SearchOperation operation, Object value) {
        return this.or(fieldName, operation, value, null);
    }

    public SearchCriteria where(SearchCriteria criteria) {
        return this.and(criteria);
    }

    public SearchCriteria and(SearchCriteria criteria) {
        this.expressions.add(new SearchExpression(AND, criteria));
        return this;
    }

    public SearchCriteria or(SearchCriteria criteria) {
        this.expressions.add(new SearchExpression(OR, criteria));
        return this;
    }

    public SearchCriteria orderBy(String ... fields) {
        this.orderBy = fields;
        return this;
    }

    public List<String> getOrderBy() {
        if (this.orderBy == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(this.orderBy));
    }

    public List<SearchExpression> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={CategoryType.class, PluginStatus.class, PluginVersionStatus.class, ReviewStatus.class})
    public static class SearchExpression {
        private String type;
        private String fieldname;
        private SearchOperation operation;
        private Object value;
        private String function;
        private SearchCriteria criteria;

        public SearchExpression(String type, SearchCriteria criteria) {
            if (criteria == null) {
                throw new IllegalArgumentException("Cannot have a null criteria");
            }
            this.type = type;
            this.criteria = criteria;
        }

        public SearchExpression(String type, String fieldname, SearchOperation operation, Object value, String function) {
            if (fieldname == null) {
                throw new IllegalArgumentException("Cannot have a null field name");
            }
            if (operation == null) {
                throw new IllegalArgumentException("Cannot have a null search operation");
            }
            if (operation.isSubstituted() && value == null) {
                throw new IllegalArgumentException("Search operation " + (Object)((Object)operation) + " requires a value");
            }
            if (!operation.isSubstituted() && value != null) {
                throw new IllegalArgumentException("Search operation " + (Object)((Object)operation) + " does not require a value");
            }
            this.type = type;
            this.fieldname = fieldname;
            this.operation = operation;
            this.value = value;
            this.function = function;
        }

        private SearchExpression() {
        }

        public String getType() {
            return this.type;
        }

        public String getFieldname() {
            return this.fieldname;
        }

        public SearchOperation getOperation() {
            return this.operation;
        }

        public Object getValue() {
            return this.value;
        }

        public String getFunction() {
            return this.function;
        }

        public SearchCriteria getCriteria() {
            return this.criteria;
        }
    }
}

