package com.atlassian.plugins.service.plugin;

import com.atlassian.plugins.domain.model.plugin.Plugin;
import com.atlassian.plugins.domain.model.plugin.PluginEntry;
import com.atlassian.plugins.service.RestService;

import java.util.List;
import java.util.Date;

public interface PluginService extends RestService<Plugin> {

    public static final String PATH = "/plugin";

    public static final String PATH_POPULARPLUGINS = "/popular";
    public static final String PATH_RECENTPLUGINS = "/recent";
    public static final String PATH_PLUGINSBYCATEGORY = "/category";
    public static final String PATH_PLUGINSBYCATEGORYCOUNT = "/categorycount";
    public static final String PATH_PLUGINSBYPLUGINKEY = "/pluginkey";   
    public static final String PATH_SEARCH = "/search";
    public static final String PATH_SEARCHCOUNT = "/searchcount";
    public static final String PATH_SEARCHINDEX = "/searchindex";
    public static final String PATH_NUMBER = "/number";

    public static final String PATHCOMPONENT_SEARCH_ALL_PRODUCTS = "all";

    public static final String PARAM_QUERY = "q";
    public static final String PARAM_PLUGINKEYS = "pk";

    public static final String FORMAT_AGGREGATE_DATE = "yyyy-MM-dd";

    public List<Plugin> popularPlugins(Integer max, Integer offset, List<String> expand);

    public List<Plugin> popularPlugins(Integer max, Integer offset, List<String> expand, String categoryId);

    public List<Plugin> recentlyUpdatedPlugins(String categoryId, Integer max, Integer offset, List<String> expand);

    public List<Plugin> pluginsByCategory(String categoryId, Integer max, Integer offset, List<String> expand);

    public List<Plugin> pluginsByPluginKey(List<String> pluginKeys, Integer max, Integer offset, List<String> expand);

    public Long countPluginsByCategory(String categoryId);

    public List<Plugin> searchPlugins(String categoryKey, String query, Integer max, Integer offset, List<String> expand);

    public Long searchPluginsCount(String categoryKey, String query);

    public void reindexPlugins();

    public List<PluginEntry> getNumberOfPlugins(String product, Date start, Date end, String period,
        String countVersions, String cumulative);

}
