package com.atlassian.plugins.service.plugin;

import com.atlassian.plugins.domain.model.plugin.Download;
import com.atlassian.plugins.service.RestService;

import java.util.Date;
import java.util.List;

public interface DownloadService extends RestService<Download> {

    public static final String PATH = "/download";

    public static final String PATH_TOTALFORPLUGIN = "/total/plugin";
    public static final String PATH_TOTALFORPLUGINVERSION = "/total/pluginVersion";
    public static final String PATH_DOWNLOAD = "/pluginVersion";
    public static final String PATH_DOWNLOAD_LATEST_VERSION = "/plugin";
    public static final String PATH_AGGREGATE_WEEKS = "/aggregate/weeks";
    public static final String PATH_AGGREGATE_MONTHS = "/aggregate/months";
    public static final String PATH_AGGREGATE = "/aggregate";

    public static final String PARAM_SERVERID = "sid";

    public static final String FORMAT_AGGREGATE_DATE = "yyyy-MM-dd";

    public static final String MONTHLY = "monthly";
    public static final String WEEKLY = "weekly";

    public static final String ALL_PRODUCTS = "*";
    public static final String ALL_PLUGIN_IDS = "-1";  

    public Long totalDownloadsForPlugin(String pluginId);

    public Long totalDownloadsForPluginVersion(String pluginVersionId);

    public String downloadPluginVersion(String pluginVersionId);

    public List<Download> getDownloads(String pluginId, String product, Date start, Date end, String period);

}