package com.atlassian.plugins.service.category;

import com.atlassian.plugins.domain.model.category.Category;
import com.atlassian.plugins.domain.model.category.CategoryType;
import com.atlassian.plugins.service.RestService;

import java.util.List;

public interface CategoryService extends RestService<Category> {

    public static final String PATH = "/category";

    public static final String PATH_FINDPARENTCATEGORY = "/find/parentCategory";
    public static final String PATH_FINDPARENTCATEGORIES = "/find/parentCategories";
    public static final String PATH_FINDCHILDCATEGORIES = "/find/childCategories";
    public static final String PATH_FINDCATEGORYHIERARCHY = "/find/categoryHierarchy";

    public static final String PARAM_KEY = "key";

    public List<Category> findParentCategory(CategoryType type);

    public List<Category> findParentCategories(String categoryId);

    public List<Category> findChildCategories(String categoryId, Boolean includeInactiveCategories);

    public List<Category> findCategoryHierarchyWithKeys(List<String> keys);

}