package com.atlassian.plugins.domain.model.vendor;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.user.User;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class VendorRelationship extends AbstractDTO {

    public static final String EXPAND_USER = "user";
    public static final String EXPAND_VENDOR = "vendor";

    @XmlElement
    @Expand(EXPAND_USER)
    private User user;

    @XmlElement
    @Expand(EXPAND_VENDOR)
    private Vendor vendor;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {        
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }
}
