package com.atlassian.plugins.domain.model.vendor;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.plugin.Plugin;
import com.atlassian.plugins.domain.wrapper.ListWrapper;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Vendor extends AbstractDTO {

    public static final String EXPAND_PLUGIN = "plugin";
    public static final String EXPAND_PLUGINS = "plugins";
    public static final String EXPAND_SUPPORT_ORGANISATION = "supportOrganisation";
    public static final String EXPAND_SUPPORT_ORGANISATIONS = "supportOrganisations";
    public static final String EXPAND_VENDOR_RELATIONSHIP = "vendorRelationship";
    public static final String EXPAND_VENDOR_RELATIONSHIPS = "vendorRelationships";

    private String name;

    private String addressLine1;

    private String addressLine2;

    private String city;

    private String state;

    private String postCode;

    private String country;

    /**
     * If web support is offered, the website
     */
    private String url;

    /**
     * If email support is offered, the email
     */
    private String email;

    /**
     * If phone support is offered, the phone number
     */
    private String phone;

    /**
     * If other support is offered, the other contact details
     */
    private String otherContactDetails;

    /**
     * The username of the user who created this vendor
     */
    private String createdBy;

    /**
     * List of support organisations
     */
    @Expand(EXPAND_SUPPORT_ORGANISATIONS)
    @XmlElement
    private ListWrapper<SupportOrganisation> supportOrganisations = new ListWrapper<SupportOrganisation>();

    /**
     * List of the users associated to this vendor
     */
    @Expand(EXPAND_VENDOR_RELATIONSHIPS)
    @XmlElement
    private ListWrapper<VendorRelationship> vendorRelationships = new ListWrapper<VendorRelationship>();

    /**
     * List of plugins associated to this vendor
     */
    @Expand(EXPAND_PLUGINS)
    @XmlElement
    private ListWrapper<Plugin> plugins = new ListWrapper<Plugin>();

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
            put("supportOrganisations", supportOrganisations);
            put("vendorRelationships", vendorRelationships);
            put("plugins", plugins);
            supportOrganisations = null;
            vendorRelationships = null;
            plugins = null;
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
            supportOrganisations = (ListWrapper) get("supportOrganisations");
            vendorRelationships = (ListWrapper) get("vendorRelationships");
            plugins = (ListWrapper) get("plugins");
        }
    }

    public boolean hasUsername(String username) {
        
        if (username == null || vendorRelationships == null) return false;

        for (VendorRelationship vendorRelationship : vendorRelationships)
        {
            if (vendorRelationship != null && vendorRelationship.getUser() != null && vendorRelationship.getUser().getUsername() != null &&
                vendorRelationship.getUser().getUsername().equals(username))
                return true;
        }

        return false;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddressLine1() {
        return addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOtherContactDetails() {
        return otherContactDetails;
    }

    public void setOtherContactDetails(String otherContactDetails) {
        this.otherContactDetails = otherContactDetails;
    }

    public ListWrapper<SupportOrganisation> getSupportOrganisations() {
        return supportOrganisations;
    }

    public void setSupportOrganisations(ListWrapper<SupportOrganisation> supportOrganisations) {
        this.supportOrganisations = supportOrganisations;
    }

    public ListWrapper<VendorRelationship> getVendorRelationships() {
        return vendorRelationships;
    }

    public void setVendorRelationships(ListWrapper<VendorRelationship> vendorRelationships) {
        this.vendorRelationships = vendorRelationships;
    }

    public ListWrapper<Plugin> getPlugins() {
        return plugins;
    }

    public void setPlugins(ListWrapper<Plugin> plugins) {
        this.plugins = plugins;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }
}
