package com.atlassian.plugins.domain.model.vendor;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.wrapper.ListWrapper;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class SupportOrganisation extends AbstractDTO {

    public static final String EXPAND_VENDOR = "vendor";
    public static final String EXPAND_SUPPORTDETAILS = "supportDetails";
    public static final String EXPAND_SUPPORTDETAIL = "supportDetail";

    private String name;

    @Expand(EXPAND_VENDOR)
    private Vendor vendor;

    @Expand(EXPAND_SUPPORTDETAILS)
    private ListWrapper<SupportDetail> supportDetails = new ListWrapper<SupportDetail>();

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
            put("supportDetails", supportDetails);
            supportDetails = null;
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
            supportDetails = (ListWrapper) get("supportDetails");
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public ListWrapper<SupportDetail> getSupportDetails() {
        return supportDetails;
    }

    public void setSupportDetails(ListWrapper<SupportDetail> supportDetails) {
        this.supportDetails = supportDetails;
    }

}
