package com.atlassian.plugins.domain.model.vendor;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class SupportDetail extends AbstractDTO {

    public static final String EXPAND_SUPPORT_ORGANISATION = "supportOrganisation";

    /*
     * The name of the label (Email, URL, etc)
     */
    private String label;

    /**
     * The detail text
     */
    private String text;

    /**
     * Sort order - lets us sort the details
     */
    private Integer sortOrder = 1;

    @Expand(EXPAND_SUPPORT_ORGANISATION)
    private SupportOrganisation supportOrganisation;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
            put("sortOrder", sortOrder);
            sortOrder = null;
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
            sortOrder = (Integer) get("sortOrder");
        }
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public SupportOrganisation getSupportOrganisation() {
        return supportOrganisation;
    }

    public void setSupportOrganisation(SupportOrganisation supportOrganisation) {
        this.supportOrganisation = supportOrganisation;
    }

}
