package com.atlassian.plugins.domain.model.user;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * An application user.
 *
 * Some fields will be null depending on who is requestion information - e.g email address is never shared
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class User extends AbstractDTO {

    public static final String EXPAND_AVATAR = "avatar";

    private String username;

    private String email;

    private String homepage;

    private String firstName;

    private String lastName;

    private String displayName;

    /**
     * If a new profile needs to be created, a password is required for Crowd
     */
    private String password;

    @Expand(EXPAND_AVATAR)
    private Avatar avatar;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHomepage() {
        return homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Avatar getAvatar() {
        return avatar;
    }

    public void setAvatar(Avatar avatar) {
        this.avatar = avatar;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
