package com.atlassian.plugins.domain.model.product;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.category.Category;
import com.atlassian.plugins.domain.model.plugin.PluginVersion;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Maps a plugin version to a product 
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class ProductCompatibility extends AbstractDTO {

    public static final String EXPAND_PRODUCT = "product";
    public static final String EXPAND_MINVERSION = "minVersion";
    public static final String EXPAND_MAXVERSION = "maxVersion";
    public static final String EXPAND_PLUGINVERSION = "pluginVersion";

    @Expand(EXPAND_PLUGINVERSION)
    private PluginVersion pluginVersion;

    @Expand(EXPAND_PRODUCT)
    private Category product;

    @Expand(EXPAND_MINVERSION)
    private Category minVersion;

    @Expand(EXPAND_MAXVERSION)
    private Category maxVersion;

    private Boolean minInclusive;

    private Boolean maxInclusive;

    private String comment;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {}

    public PluginVersion getPluginVersion() {
        return pluginVersion;
    }

    public void setPluginVersion(PluginVersion pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public Category getProduct() {
        return product;
    }

    public void setProduct(Category product) {
        this.product = product;
    }

    public Category getMinVersion() {
        return minVersion;
    }

    public void setMinVersion(Category minVersion) {
        this.minVersion = minVersion;
    }

    public Category getMaxVersion() {
        return maxVersion;
    }

    public void setMaxVersion(Category maxVersion) {
        this.maxVersion = maxVersion;
    }

    public Boolean getMinInclusive() {
        return minInclusive;
    }

    public void setMinInclusive(Boolean minInclusive) {
        this.minInclusive = minInclusive;
    }

    public Boolean getMaxInclusive() {
        return maxInclusive;
    }

    public void setMaxInclusive(Boolean maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}
