package com.atlassian.plugins.domain.model.product;

import com.atlassian.plugins.domain.AbstractDTO;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.Marshaller;

/**
 * A read-only object that contains information about an instance of an Atlassian product - e.g. Confluence v2.9.2s - To be used by the UPM only
 *
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Product extends AbstractDTO {

    private String product;

    private String versionNumber;

    private Long buildNumber;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
    }

    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getVersionNumber() {
        return versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public Long getBuildNumber() {
        return buildNumber;
    }

    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }
}
