package com.atlassian.plugins.domain.model.product;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class CompatibilityMatrixData implements Comparable<CompatibilityMatrixData> {

    private String version;

    private Integer sortOrder;

    private CompatibilityStatus compatible = CompatibilityStatus.INCOMPATIBLE;

    public int compareTo(CompatibilityMatrixData other) {
        int result = this.sortOrder.compareTo(other.sortOrder);
        if (result == 0) {
            result = this.version.compareTo(other.version);
        }
        return result;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public CompatibilityStatus getCompatible() {
        return compatible;
    }

    public void setCompatible(CompatibilityStatus compatible) {
        this.compatible = compatible;
    }
}
