package com.atlassian.plugins.domain.model.product;

import com.atlassian.plugins.domain.model.category.Category;
import com.atlassian.plugins.domain.model.plugin.PluginVersion;

import javax.xml.bind.annotation.*;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class CompatibilityMatrix implements Comparable<CompatibilityMatrix> {

    private PluginVersion pluginVersion;

    private Category product;

    @XmlElementWrapper(name="compatibilities")
    @XmlElement(name="compatibility")
    private List<CompatibilityMatrixData> data = new ArrayList<CompatibilityMatrixData>();

    public int compareTo(CompatibilityMatrix o1) {
        int result = new Integer(this.getProduct().getSortOrder()).compareTo(o1.getProduct().getSortOrder());
        if (result != 0) return result;
        result = o1.pluginVersion.getBuildNumber().compareTo(this.pluginVersion.getBuildNumber()); //need latest plugin version first
        if (result != 0) return result;
        return this.pluginVersion.getId().compareTo(o1.pluginVersion.getId());
    }

    public PluginVersion getPluginVersion() {
        return pluginVersion;
    }

    public void setPluginVersion(PluginVersion pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public Category getProduct() {
        return product;
    }

    public void setProduct(Category product) {
        this.product = product;
    }

    public List<CompatibilityMatrixData> getData() {
        return data;
    }

    public void setData(List<CompatibilityMatrixData> data) {
        this.data = data;
    }
}
