package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Screenshot extends AbstractDTO {

    public static final String EXPAND_PLUGIN = "plugin";

    /**
     * Image name - does not have to be unique -- can be a key
     */
    private String name;

    /**
     * Sort order - for images of the same type, allows for an order to be specified
     */
    private Integer sortOrder;

    /**
     * The location of the actual file
     */
    private String location;

    /**
     * The alternative text
     */
    private String altText;

    /**
     * The image width in pixels
     */
    private Integer width;

    /**
     * The image height in pixels
     */
    private Integer height;

    /**
     * The file type
     */
    private String imageType;    

    /**
     * The plugin the screenshot is for
     */
    @Expand(EXPAND_PLUGIN)
    private Plugin plugin;

    public boolean beforeMarshal(Marshaller m) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {}

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getAltText() {
        return altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Plugin getPlugin() {
        return plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }
}
