package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Legacy plugins express their requirements through this class -- no new plugins should use this.
 *
 * It specifies the pre-installation requirements for this version to install.
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Requirement extends AbstractDTO {

    public static final String EXPAND_PLUGINVERSION = "pluginVersion";

    @Expand(EXPAND_PLUGINVERSION)
    private PluginVersion pluginVersion;

    /**
     * The key of the plugin that should be installed
     */
    private String pluginKey;

    /*
     * The class which must be loadable in the confluence webapp
     */
    private String className;

    /**
     * The error message to show if it fails
     */
    private String errorMessage;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
    }

    public void setExpand(String expand) {
        //do nothing as this object is always expanded
    }

    public PluginVersion getPluginVersion() {
        return pluginVersion;
    }

    public void setPluginVersion(PluginVersion pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getPluginKey() {
        return pluginKey;
    }

    public void setPluginKey(String pluginKey) {
        this.pluginKey = pluginKey;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

}
