package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

/**
 * This class tracks the number of plugins created by date
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class PluginEntry extends AbstractDTO implements Comparable<PluginEntry> {

    private Long count = 1L;
    private Date period;
    private String product;

    public boolean beforeMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
    }


    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Date getPeriod()
    {
        return period;
    }

    public void setPeriod(Date period)
    {
        this.period = period;
    }

    public String getProduct()
    {
        return product;
    }

    public void setProduct(String product)
    {
        this.product = product;
    }

    public int compareTo(PluginEntry pluginEntry)
    {
        return this.period.compareTo(pluginEntry.getPeriod());        
    }
}