package com.atlassian.plugins.domain.model.plugin;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * A read-only object that contains information about the compatibility of a single plugin with various versions of a
 * product.
 */

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class PluginCompatibilityStatus
{
    /**
     * Whether or not the version of the plugin referenced by this object is compatible with some specific of the
     * product. This field is used by clients to determine if the plugin wil still work after upgrading to the latest
     * version of the product. 
     */
    private Boolean currentPluginCompatibleWithSpecifiedVersionOfProduct;
    
    /**
     * Whether or not this version of the plugin is the latest build/version of the plugin. This field is used by
     * clients to determine whether or not they are using the latest version of the plugin (and if an upgrade is
     * available).
     */
    private Boolean currentPluginLatestBuild;
    
    /**
     * Whether or not the latest version of this plugin (which may not be the version referenced by this object) is
     * compatible with some specific version of this product. This field is used by clients to determine if things will
     * keep working if they upgrade both the product and the plugin to their latest versions. 
     */
    private Boolean latestPluginVersionCompatibleWithSpecifiedProductVersion;

    /**
     * Whether or not the latest version of this plugin (which may not be the version referenced by this object) is
     * compatible with the current version of this product. This field is used by clients to determine if it is safe
     * to upgrade the plugin to the latest version but not upgrade the product.
     */
    private Boolean latestPluginVersionCompatibleWithCurrentProductVersion;

    /**
     * We really just need this for the binary url. Something equivalent that provided the url for the latest binary
     * would work too :)
     */
    private PluginVersion latestCompatiblePluginVersion;

    /**
     * The latest version of this plugin.
     */
    @XmlAttribute
    private String latestVersion;


    private String pluginKey;

    public Boolean getCurrentPluginCompatibleWithSpecifiedVersionOfProduct()
    {
        return currentPluginCompatibleWithSpecifiedVersionOfProduct;
    }

    public Boolean getCurrentPluginLatestBuild()
    {
        return currentPluginLatestBuild;
    }

    public Boolean getLatestPluginVersionCompatibleWithSpecifiedProductVersion()
    {
        return latestPluginVersionCompatibleWithSpecifiedProductVersion;
    }

    public Boolean getLatestPluginVersionCompatibleWithCurrentProductVersion()
    {
        return latestPluginVersionCompatibleWithCurrentProductVersion;
    }
    
    public void setCurrentPluginCompatibleWithSpecifiedVersionOfProduct(Boolean currentPluginCompatibleWithSpecifiedVersionOfProduct)
    {
        this.currentPluginCompatibleWithSpecifiedVersionOfProduct = currentPluginCompatibleWithSpecifiedVersionOfProduct;
    }

    public void setCurrentPluginLatestBuild(Boolean currentPluginLatestBuild)
    {
        this.currentPluginLatestBuild = currentPluginLatestBuild;
    }

    public void setLatestPluginVersionCompatibleWithSpecifiedProductVersion(Boolean latestPluginVersionCompatibleWithSpecifiedProductVersion)
    {
        this.latestPluginVersionCompatibleWithSpecifiedProductVersion = latestPluginVersionCompatibleWithSpecifiedProductVersion;
    }
    
    public void setLatestPluginVersionCompatibleWithCurrentProductVersion(Boolean latestPluginVersionCompatibleWithCurrentProductVersion)
    {
        this.latestPluginVersionCompatibleWithCurrentProductVersion = latestPluginVersionCompatibleWithCurrentProductVersion;
    }

    public String getLatestVersion()
    {
        return latestVersion;
    }

    public void setLatestVersion(String latestVersion)
    {
        this.latestVersion = latestVersion;
    }

    public String getPluginKey()
    {
        return pluginKey;
    }

    public void setPluginKey(String pluginKey)
    {
        this.pluginKey = pluginKey;
    }

    public PluginVersion getLatestCompatiblePluginVersion()
    {
        return latestCompatiblePluginVersion;
    }

    public void setLatestCompatiblePluginVersion(PluginVersion latestCompatiblePluginVersion)
    {
        this.latestCompatiblePluginVersion = latestCompatiblePluginVersion;
    }
}
