package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Plugins each have a unique key. This class stores previous keys for the plugin.
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class HistoricalKey extends AbstractDTO {

    private Plugin plugin;

    private String key;

    public boolean beforeMarshal(Marshaller marshaller) {
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
        //do nothing
    }

    public Plugin getPlugin() {
        return plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}
