package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * This class tracks plugin/version downloads
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Download extends AbstractDTO {

    public static final String EXPAND_PLUGIN = "plugin";
    public static final String EXPAND_PLUGINVERSION = "pluginVersion";

    @Expand(EXPAND_PLUGIN)
    private Plugin plugin;

    @Expand(EXPAND_PLUGINVERSION)
    private PluginVersion pluginVersion;

    private String serverId;

    private Long total = 1L;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
    }

    public Plugin getPlugin() {
        return plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public PluginVersion getPluginVersion() {
        return pluginVersion;
    }

    public void setPluginVersion(PluginVersion pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getServerId() {
        return serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }
}
