package com.atlassian.plugins.domain.model.country;

import com.atlassian.plugins.domain.AbstractDTO;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents a country.
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Country extends AbstractDTO implements Comparable<Country> {

    /**
     * Printable name of the country (Mongo, New Caprica, Romulus).
     */
    private String displayName;

    /**
     * 2-letter ISO code for the country.
     */
    private String isoCode;

    /**
     * Defined sort order for the country.
     */
    private Integer sortOrder;

    @Override
    public void afterMarshal(Marshaller marshaller) {}

    @Override
    public boolean beforeMarshal(Marshaller marshaller) { return true; }

    public int compareTo(Country that) {
        if (this.sortOrder != null && that.sortOrder != null) {
            return this.sortOrder.compareTo(that.sortOrder);
        }
        if (this.sortOrder != null && that.sortOrder == null) {
            return -1;
        }
        if (that.sortOrder != null && this.sortOrder == null) {
            return 1;
        }
        else return this.displayName.compareTo(that.displayName);
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getIsoCode() {
        return isoCode;
    }

    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public String toString() {
        return displayName;
    }
}
