package com.atlassian.plugins.domain.model.category;

import javax.xml.bind.annotation.XmlType;

/**
 * Categories that need to be referred to in code require a key so they can be easily retrieved.
 *
 * The default type is "CATEGORY"
 *
 */
@XmlType
public enum CategoryType {

    //basic plugin category - acts like the default
    CATEGORY(true),

    //e.g. alpha, beta, rc, stable
    STATE,

    //e.g. BSD, LGPL
    LICENSETYPE,

    //e.g.
    //1 - Initial release
    //2 - Documentation
    //3 - Code cleanup
    //4 - Minor feature enhancements
    //5 - Major feature enhancements
    //6 - Minor bugfixes
    //7 - Major bugfixes
    //8 - Minor security fixes
    //9 - Major security fixes
    RELEASEFOCUS,

    //Atlassian products here, eg Confluence, Confluence 2.10,
    PRODUCT(true),

    //contributor role, e.g. AUTHOR, CONTRIBUTOR, DEVELOPER, LEAD-DEVELOPER
    CONTRIBUTOR,

    //website resources, e.g. support information, resource list
    RESOURCE;

    private final boolean nested;

    CategoryType() {
         this(false);
     }

    CategoryType(boolean nested) {
        this.nested = nested;
    }

    public boolean isNested() {
        return nested;
    }
}
