package com.atlassian.plugins.domain.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Any request which produces a status code with no body, returns a status body instead
 */
@XmlRootElement(name="status")
@XmlAccessorType(XmlAccessType.FIELD)
public class Status {

    @XmlElement(name="status-code")
    private String code;

    @XmlElement(name="sub-code")
    private String subCode;

    private String message;

    private String etag;

    @XmlElement(name="resources-created")
    private List<Link> resourcesCreated = new ArrayList<Link>();

    @XmlElement(name="resources-updated")
    private List<Link> resourcesUpdated = new ArrayList<Link>();

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSubCode() {
        return subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getEtag() {
        return etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public List<Link> getResourcesCreated() {
        return resourcesCreated;
    }

    public void setResourcesCreated(List<Link> resourcesCreated) {
        this.resourcesCreated = resourcesCreated;
    }

    public List<Link> getResourcesUpdated() {
        return resourcesUpdated;
    }

    public void setResourcesUpdated(List<Link> resourcesUpdated) {
        this.resourcesUpdated = resourcesUpdated;
    }
}
