package com.atlassian.plugins.domain.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="link")
public class Link {

    private String href;

    private String rel = "self";

    private String etag;

    private String id;

    public Link() {}

    public Link(String id) {        
        this.id = id;
    }

    public Link(Link link) {
        this.id = link.getId();
    }

    /*
     * JAXB foo required for proper marshalling / unmarshalling of Link
     */
    @XmlAttribute(name="href")
    private String getHref_() {
        if (this.href == null || this.id == null) return "";
        return this.href + id;
    }

    /*
     * See comment on getHref_()
     */
    private void setHref_(String href) {
        if (href != null) {
            int index = href.lastIndexOf("/");
            if (index > -1) {
                this.href = href.substring(0, index);
                this.id = href.substring(index+1);
                return;
            }
        }
        this.href = null;
        this.id = null;
    }

    @XmlTransient
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlTransient
    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @XmlAttribute    
    public String getRel() {
        return rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    @XmlTransient
    public String getEtag() {
        return etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

}
