/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.review;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.review.Review;
import com.atlassian.plugins.domain.model.review.ReviewStatus;
import com.atlassian.plugins.service.review.ReviewService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewServiceClientImpl
extends AbstractRestServiceClient<Review>
implements ReviewService {
    @Override
    protected Class<Review> getEntity() {
        return Review.class;
    }

    @Override
    protected String getPath() {
        return "/review";
    }

    public Long totalReviewsForPlugin(String pluginId, ReviewStatus reviewStatus) {
        WebResource webResource = this.getWebResource();
        String path = "plugin/" + pluginId + "/count";
        if (reviewStatus != null) {
            path = "plugin/" + pluginId + "/" + reviewStatus + "/count";
        }
        webResource = webResource.path(path);
        ClientResponse response = (ClientResponse)webResource.type("application/xml").get(ClientResponse.class);
        String total = (String)this.getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public Double averageRatingForPlugin(String pluginId, ReviewStatus reviewStatus) {
        ClientResponse response;
        WebResource webResource = this.getWebResource();
        String path = "plugin/" + pluginId + "/average";
        if (reviewStatus != null) {
            path = "plugin/" + pluginId + "/" + reviewStatus + "/average";
        }
        if ((response = (ClientResponse)(webResource = webResource.path(path)).get(ClientResponse.class)).getStatus() == 204) {
            return null;
        }
        String average = (String)this.getEntityFromResponse(response, String.class);
        return new Double(average);
    }

    public Long totalReviewsForPluginVersion(String pluginVersionId, ReviewStatus reviewStatus) {
        WebResource webResource = this.getWebResource();
        String path = "pluginVersion/" + pluginVersionId + "/count";
        if (reviewStatus != null) {
            path = "pluginVersion/" + pluginVersionId + "/" + reviewStatus + "/count";
        }
        webResource = webResource.path(path);
        ClientResponse response = (ClientResponse)webResource.type("application/xml").get(ClientResponse.class);
        String total = (String)this.getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public Double averageRatingForPluginVersion(String pluginVersionId, ReviewStatus reviewStatus) {
        ClientResponse response;
        WebResource webResource = this.getWebResource();
        String path = "pluginVersion/" + pluginVersionId + "/average";
        if (reviewStatus != null) {
            path = "pluginVersion/" + pluginVersionId + "/" + reviewStatus + "/average";
        }
        if ((response = (ClientResponse)(webResource = webResource.path(path)).get(ClientResponse.class)).getStatus() == 204) {
            return null;
        }
        String average = (String)this.getEntityFromResponse(response, String.class);
        return new Double(average);
    }
}

