/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.product;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.product.CompatibilityMatrix;
import com.atlassian.plugins.domain.model.product.ProductCompatibility;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.product.ProductCompatibilityService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCompatibilityServiceClientImpl
extends AbstractRestServiceClient<ProductCompatibility>
implements ProductCompatibilityService {
    @Override
    protected Class<ProductCompatibility> getEntity() {
        return ProductCompatibility.class;
    }

    @Override
    protected String getPath() {
        return "/productcompatibility";
    }

    public List<CompatibilityMatrix> findCompatibilityMatrix(String pluginId, String reductionType, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/matrix/" + pluginId);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (reductionType != null) {
            map.putSingle("r", reductionType);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList<CompatibilityMatrix>();
        }
        return listWrapper.getList();
    }

    public List<ProductCompatibility> getUpgradeablePluginVersions(String categoryId, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/autoupdate");
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (StringUtils.isNotBlank((String)categoryId)) {
            map.putSingle("categoryId", categoryId);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        return (listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() != null ? listWrapper.getList() : Collections.emptyList();
    }

    public List<ProductCompatibility> upgradePluginVersions(String toCategoryId, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/autoupdate");
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (StringUtils.isNotBlank((String)toCategoryId)) {
            map.putSingle("categoryId", toCategoryId);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        return (listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(ClientResponse.class, (Object)map), ListWrapper.class)).getList() != null ? listWrapper.getList() : Collections.emptyList();
    }
}

