/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.PacException;
import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.Status;
import com.atlassian.plugins.domain.model.plugin.Screenshot;
import com.atlassian.plugins.service.plugin.ScreenshotService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenshotServiceClientImpl
extends AbstractRestServiceClient<Screenshot>
implements ScreenshotService {
    @Override
    protected Class<Screenshot> getEntity() {
        return Screenshot.class;
    }

    @Override
    protected String getPath() {
        return "/screenshot";
    }

    public InputStream fetch(String id) {
        throw new UnsupportedOperationException("Fetch should be called directly, not through the client");
    }

    public void upload(InputStream in, Screenshot screenshot) {
        screenshot.setExpanded(true);
        if (screenshot.getId() == null) {
            String id = this.create(screenshot);
            screenshot.setId(id);
        } else {
            this.update(screenshot.getId(), screenshot);
        }
        String boundary = "boundary_" + screenshot.getId() + "_" + System.currentTimeMillis();
        WebResource.Builder webResource = this.buildWebResource(this.getWebResource().path("/" + screenshot.getId() + "/upload"));
        webResource = (WebResource.Builder)webResource.type("multipart/mixed;boundary=\"" + boundary + "\"");
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.field("file", (Object)in, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)multiPart);
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return;
        }
        Status status = (Status)this.getEntityFromResponse(response, Status.class);
        throw new PacException("Unexpected Response: " + response.getStatus(), status);
    }
}

