/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.plugin.Plugin;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.plugin.PluginService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginServiceClientImpl
extends AbstractRestServiceClient<Plugin>
implements PluginService {
    @Override
    protected Class<Plugin> getEntity() {
        return Plugin.class;
    }

    @Override
    protected String getPath() {
        return "/plugin";
    }

    public List<Plugin> popularPlugins(Integer max, Integer offset, List<String> expand) {
        return this.popularPlugins(max, offset, expand, null);
    }

    public List<Plugin> popularPlugins(Integer max, Integer offset, List<String> expand, String categoryId) {
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
        }
        if (categoryId != null) {
            map.putSingle("category", categoryId);
        }
        webResource = webResource.queryParams((MultivaluedMap)map);
        ClientResponse response = (ClientResponse)(webResource = webResource.path("/popular")).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Plugin>();
        }
        return listWrapper.getList();
    }

    public List<Plugin> recentlyUpdatedPlugins(String categoryId, Integer max, Integer offset, List<String> expand) {
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
        }
        if (categoryId != null) {
            map.putSingle("category", categoryId);
        }
        webResource = webResource.queryParams((MultivaluedMap)map);
        ClientResponse response = (ClientResponse)(webResource = webResource.path("/recent")).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Plugin>();
        }
        return listWrapper.getList();
    }

    public List<Plugin> pluginsByCategory(String categoryId, Integer max, Integer offset, List<String> expand) {
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
        }
        webResource = webResource.queryParams((MultivaluedMap)map);
        ClientResponse response = (ClientResponse)(webResource = webResource.path("/category/" + categoryId)).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Plugin>();
        }
        return listWrapper.getList();
    }

    public List<Plugin> pluginsByPluginKey(List<String> pluginKeys, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
        }
        webResource = webResource.queryParams((MultivaluedMap)map);
        webResource = webResource.path("/pluginkey");
        Form form = new Form();
        if (pluginKeys != null && !pluginKeys.isEmpty()) {
            for (String pluginKey : pluginKeys) {
                form.add("pk", pluginKey);
            }
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.post(ClientResponse.class, (Object)form), ListWrapper.class)).getList() == null) {
            return new ArrayList<Plugin>();
        }
        return listWrapper.getList();
    }

    public Long countPluginsByCategory(String categoryId) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/categorycount/" + categoryId);
        ClientResponse response = (ClientResponse)webResource.type("application/xml").get(ClientResponse.class);
        String total = (String)this.getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public List<Plugin> searchPlugins(String categoryKey, String query, Integer max, Integer offset, List<String> expand) {
        String categoryKeyPath = categoryKey == null ? "all" : categoryKey;
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        map.putSingle("q", query);
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
        }
        webResource = webResource.queryParams((MultivaluedMap)map);
        ClientResponse response = (ClientResponse)(webResource = webResource.path("/search/" + categoryKeyPath)).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Plugin>();
        }
        return listWrapper.getList();
    }

    public Long searchPluginsCount(String categoryKey, String query) {
        String categoryKeyPath = categoryKey == null ? "all" : categoryKey;
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        map.putSingle("q", query);
        webResource = webResource.queryParams((MultivaluedMap)map);
        webResource = webResource.path("/searchcount/" + categoryKeyPath);
        ClientResponse response = (ClientResponse)webResource.type("application/xml").get(ClientResponse.class);
        String total = (String)this.getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public void reindexPlugins() {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/searchindex");
        ClientResponse response = (ClientResponse)this.buildWebResource(webResource).get(ClientResponse.class);
        this.getEntityFromResponse(response, null);
    }

    public List getNumberOfPlugins(String product, Date start, Date end, String period, String countVersions, String cumulative) {
        if (product == null || start == null || end == null || period == null) {
            throw new IllegalArgumentException("Product, Start Date, End Date, and Period cannot be null");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        WebResource webResource = this.getWebResource();
        ClientResponse response = (ClientResponse)this.buildWebResource(webResource = webResource.path("/number/" + product + "/" + df.format(start) + "/" + df.format(end) + "/" + period + "/" + countVersions + "/" + cumulative)).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList();
        }
        return listWrapper.getList();
    }
}

