/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.category;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.category.Category;
import com.atlassian.plugins.domain.model.category.CategoryType;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.category.CategoryService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryServiceClientImpl
extends AbstractRestServiceClient<Category>
implements CategoryService {
    @Override
    protected Class<Category> getEntity() {
        return Category.class;
    }

    @Override
    protected String getPath() {
        return "/category";
    }

    public List<Category> findParentCategory(CategoryType type) {
        WebResource webResource = this.getWebResource();
        ClientResponse response = (ClientResponse)(webResource = webResource.path("/find/parentCategory/" + type)).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Category>();
        }
        return listWrapper.getList();
    }

    public List<Category> findParentCategories(String categoryId) {
        WebResource webResource = this.getWebResource();
        ClientResponse response = (ClientResponse)(webResource = webResource.path("/find/parentCategories/" + categoryId)).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Category>();
        }
        return listWrapper.getList();
    }

    public List<Category> findChildCategories(String categoryId, Boolean includeInactiveCategories) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/childCategories/" + categoryId);
        ClientResponse response = (ClientResponse)(webResource = webResource.queryParam("includeInactiveCategories", includeInactiveCategories.toString())).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Category>();
        }
        return listWrapper.getList();
    }

    public List<Category> findCategoryHierarchyWithKeys(List<String> keys) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/categoryHierarchy");
        if (keys != null && !keys.isEmpty()) {
            MultivaluedMapImpl map = new MultivaluedMapImpl();
            StringBuffer sb = new StringBuffer();
            for (String ex : keys) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("key", sb.toString());
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList<Category>();
        }
        return listWrapper.getList();
    }
}

