package com.atlassian.plugins.less;

import com.atlassian.webresource.api.assembler.resource.PrebakeError;

import javax.annotation.Nonnull;
import java.util.List;

import static com.google.common.base.Preconditions.checkNotNull;

public class PrebakeStateResult {

    private final String state;
    private final List<PrebakeError> prebakeErrors;

    public PrebakeStateResult(@Nonnull String state, @Nonnull List<PrebakeError> prebakeErrors) {
        this.state = checkNotNull(state);
        this.prebakeErrors = checkNotNull(prebakeErrors);
    }

    public String getState() {
        return state;
    }

    public List<PrebakeError> getPrebakeErrors() {
        return prebakeErrors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PrebakeStateResult)) return false;

        PrebakeStateResult that = (PrebakeStateResult) o;

        if (!state.equals(that.state)) return false;
        return prebakeErrors.equals(that.prebakeErrors);

    }

    @Override
    public int hashCode() {
        int result = state.hashCode();
        result = 31 * result + prebakeErrors.hashCode();
        return result;
    }
}
