package com.atlassian.plugins.less;

import com.atlassian.lesscss.spi.UriResolver;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;

public class PluggableUriResolverManager implements UriResolverManager {

    private final PluginModuleTracker<UriResolver, UriResolverModuleDescriptor> uriResolvers;

    public PluggableUriResolverManager(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        uriResolvers = new DefaultPluginModuleTracker<>(
                pluginAccessor,
                pluginEventManager,
                UriResolverModuleDescriptor.class
        );
    }

    public void closeModuleTracker() {
        uriResolvers.close();
    }

    @Override
    public Iterable<UriResolver> getResolvers() {
        return uriResolvers.getModules();
    }
}
