package com.atlassian.plugins.less;

import com.atlassian.webresource.api.assembler.resource.PrebakeError;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

public class DimensionUnawareUriResolverPrebakeError<E> implements PrebakeError {

    private final E source;

    public DimensionUnawareUriResolverPrebakeError(@Nonnull E source) {
        this.source = checkNotNull(source);
    }

    @Override
    public String toString() {
        return "Encountered dimension unaware transformation: " + source.getClass().getSimpleName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DimensionUnawareUriResolverPrebakeError)) return false;

        DimensionUnawareUriResolverPrebakeError<?> that = (DimensionUnawareUriResolverPrebakeError<?>) o;

        return source.equals(that.source);

    }

    @Override
    public int hashCode() {
        return source.hashCode();
    }
}
